/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.net.InetAddress;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.ReverseDNSPostProcessor;
import org.junit.Assert;
import org.junit.Test;

public class MonitorConfigTest {
    @Test
    public void shouldPostProcessorThreadsReturnDefault() {
        MonitorConfig config = new MonitorConfig();
        int actual = config.getPostProcessorThreads();
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void shouldPostProcessorThreadsReturnConfiguredValue() {
        MonitorConfig config = new MonitorConfig();
        config.props().put("postProcessorThreads", " 5 ");
        int actual = config.getPostProcessorThreads();
        Assert.assertEquals((long)5L, (long)actual);
    }

    @Test
    public void shouldPostProcessorThreadsIgnoreNonNumber() {
        MonitorConfig config = new MonitorConfig();
        config.props().put("postProcessorThreads", "not a number");
        int actual = config.getPostProcessorThreads();
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void shouldPostProcessorThreadsIgnoreTooSmall() {
        MonitorConfig config = new MonitorConfig();
        config.props().put("postProcessorThreads", "0");
        int actual = config.getPostProcessorThreads();
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void shouldDNSCacheUseDefaultConfig() throws Exception {
        MonitorConfig config = new MonitorConfig();
        ReverseDNSPostProcessor dut = new ReverseDNSPostProcessor(config);
        RequestData req = new RequestData();
        req.setRemoteAddr(InetAddress.getLocalHost().getHostAddress());
        dut.run(req, null, null);
        Assert.assertNotNull((Object)req.getRemoteHost());
        Assert.assertTrue((String)"Cache should be working", (dut.reverseLookupCache.size() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void shouldDNSCacheIgnoreInvalidConfig() throws Exception {
        MonitorConfig config = new MonitorConfig();
        config.props().put("dnsCacheConfiguration", "this makes no sense");
        ReverseDNSPostProcessor dut = new ReverseDNSPostProcessor(config);
        RequestData req = new RequestData();
        req.setRemoteAddr(InetAddress.getLocalHost().getHostAddress());
        dut.run(req, null, null);
        Assert.assertNotNull((Object)req.getRemoteHost());
        Assert.assertTrue((String)"Cache should be working", (dut.reverseLookupCache.size() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void shouldDNSCacheUseConfig() throws Exception {
        MonitorConfig config = new MonitorConfig();
        config.props().put("dnsCacheConfiguration", "maximumSize=0");
        ReverseDNSPostProcessor dut = new ReverseDNSPostProcessor(config);
        RequestData req = new RequestData();
        req.setRemoteAddr(InetAddress.getLocalHost().getHostAddress());
        dut.run(req, null, null);
        Assert.assertNotNull((Object)req.getRemoteHost());
        Assert.assertEquals((String)"maximumSize=0 violated", (long)0L, (long)dut.reverseLookupCache.size());
    }
}

