/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.mbstyle;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleType;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.style.ResourceLocator;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.mbstyle.MapBoxStyle;
import org.geotools.util.Version;
import org.json.simple.parser.ParseException;
import org.xml.sax.EntityResolver;

public class MBStyleHandler
extends StyleHandler {
    public static final String FORMAT = "mbstyle";
    public static final String MIME_TYPE = "application/vnd.geoserver.mbstyle+json";
    static final Map<StyleType, String> TEMPLATES = new HashMap<StyleType, String>();
    private SLDHandler sldHandler;

    protected MBStyleHandler(SLDHandler sldHandler) {
        super("MBStyle", FORMAT);
        this.sldHandler = sldHandler;
    }

    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        StyledLayerDescriptor styledLayerDescriptor;
        block27: {
            if (input instanceof File) {
                File jsonFile = (File)input;
                input = new FileSystemResourceStore(jsonFile.getParentFile()).get(jsonFile.getName());
            }
            if (input instanceof Resource) {
                StyledLayerDescriptor styledLayerDescriptor2;
                block26: {
                    Resource jsonResource = (Resource)input;
                    Resource sldResource = jsonResource.parent().get(FilenameUtils.getBaseName((String)jsonResource.name()) + ".sld");
                    if (sldResource.getType() != Resource.Type.UNDEFINED && sldResource.lastmodified() > jsonResource.lastmodified()) {
                        return this.sldHandler.parse((Object)sldResource, SLDHandler.VERSION_10, resourceLocator, entityResolver);
                    }
                    Reader reader = this.toReader(input);
                    try {
                        StyledLayerDescriptor sld = this.convertToSLD(reader);
                        try (OutputStream fos = sldResource.out();){
                            this.sldHandler.encode(sld, SLDHandler.VERSION_10, true, fos);
                        }
                        styledLayerDescriptor2 = this.sldHandler.parse((Object)sldResource, SLDHandler.VERSION_10, resourceLocator, entityResolver);
                        if (reader == null) break block26;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ParseException e) {
                            throw new IOException(e);
                        }
                    }
                    reader.close();
                }
                return styledLayerDescriptor2;
            }
            Reader unusedReader = this.toReader(input);
            try {
                styledLayerDescriptor = this.convertToSLD(this.toReader(input));
                if (unusedReader == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (unusedReader != null) {
                        try {
                            unusedReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            unusedReader.close();
        }
        return styledLayerDescriptor;
    }

    private StyledLayerDescriptor convertToSLD(Reader reader) throws IOException, ParseException {
        return MapBoxStyle.parse((Reader)reader);
    }

    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        return MapBoxStyle.validate((Reader)this.toReader(input));
    }

    public String mimeType(Version version) {
        return MIME_TYPE;
    }

    public String getFileExtension() {
        return "json";
    }

    public String getCodeMirrorEditMode() {
        return "application/json";
    }

    public String getStyle(StyleType type, Color color, String colorName, String layerName) {
        String template = TEMPLATES.get(type);
        String colorCode = Integer.toHexString(color.getRGB());
        colorCode = colorCode.substring(2, colorCode.length());
        return template.replace("${colorName}", colorName).replace("${colorCode}", "#" + colorCode).replace("${layerName}", layerName);
    }

    static {
        try {
            TEMPLATES.put(StyleType.GENERIC, IOUtils.toString((InputStream)MBStyleHandler.class.getResourceAsStream("template_generic.json"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.POINT, IOUtils.toString((InputStream)MBStyleHandler.class.getResourceAsStream("template_point.json"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.POLYGON, IOUtils.toString((InputStream)MBStyleHandler.class.getResourceAsStream("template_polygon.json"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.LINE, IOUtils.toString((InputStream)MBStyleHandler.class.getResourceAsStream("template_line.json"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.RASTER, IOUtils.toString((InputStream)MBStyleHandler.class.getResourceAsStream("template_raster.json"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading up the style templates", e);
        }
    }
}

