/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.style.Style;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;

public class MBStyleControllerTest
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;
    private static SimpleNamespaceContext namespaceContext;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
        namespaceContext = new SimpleNamespaceContext();
        namespaceContext.bindNamespaceUri("sld", "http://www.opengis.net/sld");
        namespaceContext.bindNamespaceUri("ogc", "http://www.opengis.net/ogc");
        testData.addStyle(null, "teststyle", "teststyle.json", ((Object)((Object)this)).getClass(), catalog, Collections.singletonMap(SystemTestData.StyleProperty.FORMAT, "mbstyle"));
        testData.addStyle(null, "multilayer", "multilayer.json", ((Object)((Object)this)).getClass(), catalog, Collections.singletonMap(SystemTestData.StyleProperty.FORMAT, "mbstyle"));
    }

    @Before
    public void login() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    @Test
    public void getBodyAsJsonUsingAcceptHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/styles/teststyle");
        request.setMethod("GET");
        request.addHeader("Accept", (Object)"application/vnd.geoserver.mbstyle+json");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.geoserver.mbstyle+json", (Object)response.getContentType());
        String responseContent = response.getContentAsString();
        String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("teststyle.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)expected, (Object)responseContent);
    }

    @Test
    public void getInfoAsJsonUsingExtension() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/styles/teststyle.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String responseContent = response.getContentAsString();
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"style\":{\"name\":\"teststyle\",\"format\":\"mbstyle\",\"languageVersion\":{\"version\":\"1.0.0\"},\"filename\":\"teststyle.json\"}}", (Object)responseContent);
    }

    @Test
    public void getBodyAsSLDUsingAcceptHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/styles/teststyle");
        request.setMethod("GET");
        request.addHeader("Accept", (Object)"application/vnd.ogc.sld+xml");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.ogc.sld+xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("<sld:Name>test-layer</sld:Name>"));
    }

    @Test
    public void getBodyAsSLDUsingExtension() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/styles/teststyle.sld");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.ogc.sld+xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("<sld:Name>test-layer</sld:Name>"));
    }

    @Test
    public void getBodyAsSLDMultiLayer() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/styles/multilayer.sld");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.ogc.sld+xml", (Object)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)"//sld:NamedLayer[1]/sld:Name", (NamespaceContext)namespaceContext, (Matcher)Matchers.equalTo((Object)"test-source-layer1")));
        MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)"//sld:NamedLayer[2]/sld:Name", (NamespaceContext)namespaceContext, (Matcher)Matchers.equalTo((Object)"test-source-layer2")));
    }

    @Test
    public void getAsHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/styles/teststyle.html");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("<a href=\"http://localhost:8080/geoserver/rest/styles/teststyle"));
    }

    public String newMbStyle() {
        String jsonBody = "{    \"layers\": [        {            \"id\": \"foo\",            \"type\": \"circle\",            \"layout\": {                \"visibility\": \"visible\"            },            \"paint\": {                \"circle-color\": \"#FFFFFF\"            }        }    ]}";
        return jsonBody;
    }

    @Test
    public void testRawPutJson() throws Exception {
        String jsonBody = this.newMbStyle();
        Catalog cat = this.getCatalog();
        Assert.assertNull((String)"foo not available", (Object)cat.getStyleByName("foo"));
        String xml = "<style><name>foo</name><format>mbstyle</format><filename>foo.json</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)cat.getStyleByName("foo"));
        response = this.putAsServletResponse("/rest/styles/foo?raw=true", jsonBody, "application/vnd.geoserver.mbstyle+json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        GeoServerResourceLoader resources = catalog.getResourceLoader();
        Resource resource = resources.get("/styles/foo.json");
        String definition = new String(resource.getContents());
        Assert.assertTrue((String)"is json", (boolean)definition.contains("\"circle-color\": \"#FFFFFF\""));
        StyleInfo styleInfo = catalog.getStyleByName("foo");
        Style s = styleInfo.getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        String contentOut = new String(out.toByteArray());
        Assert.assertTrue((boolean)contentOut.contains("<sld:Name>foo</sld:Name>"));
        catalog.remove(styleInfo);
    }

    @Test
    public void testPostJson() throws Exception {
        String jsonBody = this.newMbStyle();
        Catalog cat = this.getCatalog();
        Assert.assertNull((String)"foo not available", (Object)cat.getStyleByName("foo"));
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=foo", jsonBody, "application/vnd.geoserver.mbstyle+json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        GeoServerResourceLoader resources = catalog.getResourceLoader();
        Resource resource = resources.get("/styles/foo.json");
        String definition = new String(resource.getContents());
        Assert.assertTrue((String)"is json", (boolean)definition.contains("\"circle-color\": \"#FFFFFF\""));
        StyleInfo styleInfo = catalog.getStyleByName("foo");
        Style s = styleInfo.getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        String contentOut = new String(out.toByteArray());
        Assert.assertTrue((boolean)contentOut.contains("<sld:Name>foo</sld:Name>"));
        catalog.remove(styleInfo);
    }
}

