/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.mbstyle.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.styling.SLD;
import org.junit.Assert;
import org.junit.Test;

public class MBStyleHandlerTest
extends GeoServerSystemTestSupport {
    @Test
    public void testParseThroughStyles() throws IOException {
        String mbstyle = "{\"layers\": [{\n    \"type\": \"line\",\n    \"paint\": {\n        \"line-color\": \"#0099ff\",\n        \"line-width\": 10,\n    }\n}]}";
        StyledLayerDescriptor sld = Styles.handler((String)"mbstyle").parse((Object)mbstyle, null, null, null);
        Assert.assertNotNull((Object)sld);
        LineSymbolizer ls = SLD.lineSymbolizer((Style)Styles.style((StyledLayerDescriptor)sld));
        Assert.assertNotNull((Object)ls);
    }

    @Test
    public void testRoundTripMBStyleGroup() throws IOException {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("citeGroup");
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.LAKES)));
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS)));
        lg.getLayers().add(catalog.getLayerByName(this.getLayerId(MockData.NAMED_PLACES)));
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        lg.getStyles().add(null);
        catalog.add(lg);
        StyledLayerDescriptor sld = Styles.handler((String)"mbstyle").parse((Object)((Object)((Object)this)).getClass().getResourceAsStream("citeGroup.json"), null, null, null);
        Assert.assertEquals((long)3L, (long)sld.getStyledLayers().length);
        StyleHandler sldHandler = Styles.handler((String)"sld");
        File sldFile = Files.createTempFile("citeGroup", "sld", new FileAttribute[0]).toFile();
        try (FileOutputStream fout = new FileOutputStream(sldFile);){
            sldHandler.encode(sld, SLDHandler.VERSION_10, true, (OutputStream)fout);
            StyledLayerDescriptor sld2 = sldHandler.parse((Object)new FileInputStream(sldFile), SLDHandler.VERSION_10, null, null);
            Assert.assertEquals((long)3L, (long)sld2.getStyledLayers().length);
        }
    }
}

