/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wfs;

import java.io.Serializable;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.InspireTestSupport;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WFSExtendedCapabilitiesTest
extends GeoServerSystemTestSupport {
    private static final String WFS_1_0_0_GETCAPREQUEST = "wfs?request=GetCapabilities&service=WFS&version=1.0.0";
    private static final String WFS_1_1_0_GETCAPREQUEST = "wfs?request=GetCapabilities&service=WFS&version=1.1.0";
    private static final String WFS_2_0_0_GETCAPREQUEST = "wfs?request=GetCapabilities&service=WFS&acceptVersions=2.0.0";

    @Test
    public void testNoInspireSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapsOff() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testExtendedCaps110WithFullSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_1_1_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "https://inspire.ec.europa.eu/schemas/inspire_dls/1.0/inspire_dls.xsd");
        Element extendedCaps = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireCommonScenario1Response(extendedCaps, "http://foo.com?bar=baz", "application/vnd.iso.19139+xml", "fre");
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("one", "http://www.geoserver.org/one"));
        ids.add((Object)new UniqueResourceIdentifier("two", "http://www.geoserver.org/two", "http://metadata.geoserver.org/id?two"));
        InspireTestSupport.assertInspireDownloadSpatialDataSetIdentifierResponse(extendedCaps, ids);
    }

    @Test
    public void testExtendedCaps200WithFullSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "https://inspire.ec.europa.eu/schemas/inspire_dls/1.0/inspire_dls.xsd");
        Element extendedCaps = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireCommonScenario1Response(extendedCaps, "http://foo.com?bar=baz", "application/vnd.iso.19139+xml", "fre");
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("one", "http://www.geoserver.org/one"));
        ids.add((Object)new UniqueResourceIdentifier("two", "http://www.geoserver.org/two", "http://metadata.geoserver.org/id?two"));
        InspireTestSupport.assertInspireDownloadSpatialDataSetIdentifierResponse(extendedCaps, ids);
    }

    @Test
    public void testReloadSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.getGeoServer().reload();
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements after settings reload", (long)1L, (long)nodeList.getLength());
    }

    @Test
    public void testExtCaps100WithFullSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_1_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testNoMetadataUrl() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testNoSpatialDataset() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testNoSpatialDatasetCode() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)",http://www.geoserver.org/one;,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testNoMediaType() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MediaType");
        Assert.assertEquals((String)"Number of MediaType elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapMissingWithRequiredSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapMissingWithoutRequiredSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testChangeMediaType() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MetadataUrl");
        Assert.assertEquals((String)"Number of MediaType elements", (long)1L, (long)nodeList.getLength());
        Element mdUrl = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireMetadataUrlResponse(mdUrl, "http://foo.com?bar=baz", "application/vnd.iso.19139+xml");
        serviceInfo.getMetadata().put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.ogc.csw.GetRecordByIdResponse_xml"));
        this.getGeoServer().save(serviceInfo);
        dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MetadataUrl");
        Assert.assertEquals((String)"Number of MediaType elements", (long)1L, (long)nodeList.getLength());
        mdUrl = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireMetadataUrlResponse(mdUrl, "http://foo.com?bar=baz", "application/vnd.ogc.csw.GetRecordByIdResponse_xml");
    }

    @Test
    public void testAddSpatialDatasetIdentifier() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "SpatialDataSetIdentifier");
        Assert.assertEquals((long)1L, (long)nodeList.getLength());
        serviceInfo.getMetadata().put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)(metadata.get((Object)InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key) + ";two,,http://metadata.geoserver.org/id?two")));
        this.getGeoServer().save(serviceInfo);
        dom = this.getAsDOM(WFS_2_0_0_GETCAPREQUEST);
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "SpatialDataSetIdentifier");
        Assert.assertEquals((long)2L, (long)nodeList.getLength());
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("one", "http://www.geoserver.org/one"));
        ids.add((Object)new UniqueResourceIdentifier("two", null, "http://metadata.geoserver.org/id?two"));
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireDownloadSpatialDataSetIdentifierResponse(extendedCaps, ids);
    }

    @Test
    public void testSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WFS_1_1_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "https://inspire.ec.europa.eu/schemas/inspire_dls/1.0/inspire_dls.xsd");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages").item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage");
        Assert.assertEquals((String)"Number of Supported Languages", (long)2L, (long)nodeList.getLength());
    }

    @Test
    public void testUnSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM("wfs?request=GetCapabilities&service=WFS&version=1.1.0&LANGUAGE=unsupported");
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "https://inspire.ec.europa.eu/schemas/inspire_dls/1.0/inspire_dls.xsd");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages").item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage");
        Assert.assertEquals((String)"Number of Supported Languages", (long)2L, (long)nodeList.getLength());
        String responseLanguage = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0).getFirstChild().getFirstChild().getNodeValue();
        Assert.assertEquals((String)"Unsupported LANGUAGE returns the Default one", (Object)"fre", (Object)responseLanguage);
    }
}

