/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.util.HashMap;
import org.geoserver.inspire.LanguagesDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class LanguageDispatcherCallbackTest
extends GeoServerSystemTestSupport {
    @Test
    public void testLanguageToAcceptLanguages() {
        Request request = new Request();
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("LANGUAGE", "ita");
        request.setRawKvp(kvp);
        request.setKvp(kvp);
        new LanguagesDispatcherCallback().init(request);
        String acceptLanguagesRawKvp = request.getRawKvp().get("ACCEPTLANGUAGES").toString();
        String acceptLanguagesKvp = request.getKvp().get("ACCEPTLANGUAGES").toString();
        Assert.assertEquals((Object)"it", (Object)acceptLanguagesRawKvp);
        Assert.assertEquals((Object)"it", (Object)acceptLanguagesKvp);
    }

    @Test
    public void testErrorMessage() {
        try {
            Request request = new Request();
            HashMap<String, String> kvp = new HashMap<String, String>();
            kvp.put("LANGUAGE", "english");
            request.setRawKvp(kvp);
            request.setKvp(kvp);
            new LanguagesDispatcherCallback().init(request);
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A Language parameter was provided in the request but it cannot be resolved to an ISO lang code."));
        }
    }
}

