/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.geofence.core.model.IPAddressRange;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.locationtech.jts.geom.MultiPolygon;

public class GeofenceRulesModel
extends GeoServerDataProvider<ShortRule> {
    private static final long serialVersionUID = 380017886089304837L;
    public static final GeoServerDataProvider.Property<ShortRule> PRIORITY = new GeoServerDataProvider.BeanProperty("priority", "priority");
    public static final GeoServerDataProvider.Property<ShortRule> ROLE = new RuleBeanProperty("roleName", "roleName");
    public static final GeoServerDataProvider.Property<ShortRule> USER = new RuleBeanProperty("userName", "userName");
    public static final GeoServerDataProvider.Property<ShortRule> SERVICE = new RuleBeanProperty("service", "service");
    public static final GeoServerDataProvider.Property<ShortRule> REQUEST = new RuleBeanProperty("request", "request");
    public static final GeoServerDataProvider.Property<ShortRule> SUBFIELD = new RuleBeanProperty("subfield", "subfield");
    public static final GeoServerDataProvider.Property<ShortRule> WORKSPACE = new RuleBeanProperty("workspace", "workspace");
    public static final GeoServerDataProvider.Property<ShortRule> LAYER = new RuleBeanProperty("layer", "layer");
    public static final GeoServerDataProvider.Property<ShortRule> ACCESS = new RuleBeanProperty("access", "access");
    public static final GeoServerDataProvider.Property<ShortRule> ADDRESS_RANGE = new RuleBeanProperty("addressRange", "addressRange");
    public static final GeoServerDataProvider.Property<ShortRule> VALID_AFTER = new RuleBeanProperty("validAfter", "validAfter");
    public static final GeoServerDataProvider.Property<ShortRule> VALID_BEFORE = new RuleBeanProperty("validBefore", "validBefore");
    public static final GeoServerDataProvider.Property<ShortRule> BUTTONS = new GeoServerDataProvider.PropertyPlaceholder("buttons");
    protected List<ShortRule> rules = GeofenceRulesModel.adminService().getAll();

    private static RuleAdminService adminService() {
        return (RuleAdminService)GeoServerApplication.get().getBean("ruleAdminService");
    }

    public GeofenceRulesModel() {
        this.setSort("priority", SortOrder.ASCENDING);
    }

    protected Comparator<ShortRule> getComparator(SortParam<?> sort) {
        return null;
    }

    public void setSort(Object property, SortOrder order) {
        super.setSort(property, order);
        Collections.sort(this.rules, super.getComparator(new SortParam(property, order == SortOrder.ASCENDING)));
    }

    public void setSort(SortParam<Object> param) {
        super.setSort(param);
        Collections.sort(this.rules, super.getComparator(param));
    }

    protected List<GeoServerDataProvider.Property<ShortRule>> getProperties() {
        return Arrays.asList(PRIORITY, ROLE, USER, SERVICE, REQUEST, SUBFIELD, WORKSPACE, LAYER, VALID_AFTER, VALID_BEFORE, ADDRESS_RANGE, ACCESS, BUTTONS);
    }

    protected List<ShortRule> getItems() {
        return this.rules;
    }

    public void save(ShortRule rule) {
        if (rule.getId() == null) {
            int i;
            this.shiftIfNecessary(rule.getPriority(), rule);
            for (i = 0; i < this.rules.size() && this.rules.get(i).getPriority() < rule.getPriority(); ++i) {
            }
            this.rules.add(i, rule);
            Rule bigRule = new Rule();
            GeofenceRulesModel.syncRule(rule, bigRule);
            rule.setId(Long.valueOf(GeofenceRulesModel.adminService().insert(bigRule)));
        } else {
            Rule bigRule = GeofenceRulesModel.adminService().get(rule.getId().longValue());
            if (bigRule.getPriority() != rule.getPriority()) {
                this.shiftIfNecessary(rule.getPriority(), rule);
            }
            GeofenceRulesModel.syncRule(rule, bigRule);
            GeofenceRulesModel.adminService().update(bigRule);
        }
    }

    public void remove(Collection<ShortRule> selected) {
        this.rules.removeAll(selected);
        for (ShortRule rule : selected) {
            GeofenceRulesModel.adminService().delete(rule.getId().longValue());
        }
    }

    public boolean canUp(ShortRule rule) {
        return this.rules.indexOf(rule) > 0;
    }

    public void moveUp(ShortRule rule) {
        int index = this.rules.indexOf(rule);
        if (index > 0) {
            this.swap(rule, this.rules.get(index - 1));
            this.rules.remove(index);
            this.rules.add(index - 1, rule);
        }
    }

    public boolean canDown(ShortRule rule) {
        return this.rules.indexOf(rule) < this.rules.size() - 1;
    }

    public void moveDown(ShortRule rule) {
        int index = this.rules.indexOf(rule);
        if (index < this.rules.size() - 1) {
            this.swap(rule, this.rules.get(index + 1));
            this.rules.remove(index);
            this.rules.add(index + 1, rule);
        }
    }

    protected void swap(ShortRule rule, ShortRule otherRule) {
        long p = otherRule.getPriority();
        otherRule.setPriority(rule.getPriority());
        rule.setPriority(p);
        GeofenceRulesModel.adminService().swap(rule.getId().longValue(), otherRule.getId().longValue());
    }

    protected void shiftIfNecessary(long priority, ShortRule keep) {
        boolean necessary = false;
        for (ShortRule rule : this.rules) {
            if (rule.getPriority() != priority) continue;
            necessary = true;
        }
        if (necessary) {
            for (ShortRule rule : this.rules) {
                if (rule.getPriority() < priority || rule == keep) continue;
                rule.setPriority(rule.getPriority() + 1L);
            }
            GeofenceRulesModel.adminService().shift(priority, 1L);
        }
    }

    public ShortRule newRule() {
        ShortRule rule = new ShortRule();
        rule.setAccess(GrantType.ALLOW);
        rule.setPriority(0L);
        return rule;
    }

    public void save(Long ruleId, MultiPolygon allowedArea, SpatialFilterType spatialFilterType, CatalogMode catalogMode) {
        Rule rule = GeofenceRulesModel.adminService().get(ruleId.longValue());
        RuleLimits ruleLimits = rule.getRuleLimits();
        if (ruleLimits == null) {
            ruleLimits = new RuleLimits();
            ruleLimits.setRule(rule);
        }
        ruleLimits.setAllowedArea(allowedArea);
        ruleLimits.setSpatialFilterType(spatialFilterType);
        ruleLimits.setCatalogMode(catalogMode);
        GeofenceRulesModel.adminService().setLimits(ruleId, ruleLimits);
    }

    public void save(Long ruleId, LayerDetails layerDetails) {
        GeofenceRulesModel.adminService().setDetails(ruleId, layerDetails);
    }

    public RuleLimits getRulesLimits(Long ruleId) {
        Rule rule;
        if (ruleId != null && (rule = GeofenceRulesModel.adminService().get(ruleId.longValue())) != null) {
            return rule.getRuleLimits();
        }
        return null;
    }

    protected static void syncRule(ShortRule shortRule, Rule rule) {
        rule.setPriority(shortRule.getPriority());
        rule.setUsername(shortRule.getUserName());
        rule.setRolename(shortRule.getRoleName());
        rule.setService(shortRule.getService());
        rule.setRequest(shortRule.getRequest());
        rule.setSubfield(shortRule.getSubfield());
        rule.setWorkspace(shortRule.getWorkspace());
        rule.setLayer(shortRule.getLayer());
        rule.setAccess(shortRule.getAccess());
        rule.setAddressRange(shortRule.getAddressRange() != null ? new IPAddressRange(shortRule.getAddressRange()) : null);
        rule.setValidAfter(shortRule.getValidAfter() == null ? null : Date.valueOf(shortRule.getValidAfter()));
        rule.setValidBefore(shortRule.getValidBefore() == null ? null : Date.valueOf(shortRule.getValidBefore()));
    }

    public LayerDetails getDetails(Long ruleId) {
        Rule rule;
        if (ruleId != null && (rule = GeofenceRulesModel.adminService().get(ruleId.longValue())) != null) {
            return rule.getLayerDetails();
        }
        return null;
    }

    public static class RuleBeanProperty<T>
    extends GeoServerDataProvider.BeanProperty<T> {
        private static final long serialVersionUID = 380019722644223446L;

        public RuleBeanProperty(String key, String propertyPath) {
            super(key, propertyPath);
        }

        public Comparator<T> getComparator() {
            return null;
        }

        public IModel getModel(IModel<T> itemModel) {
            return new PropertyModel<Object>(itemModel, this.getPropertyPath()){
                private static final long serialVersionUID = 1L;

                public Object getObject() {
                    Object o = super.getObject();
                    return o == null ? "*" : o;
                }
            };
        }
    }
}

