/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class GeofenceAdminRulesModel
extends GeoServerDataProvider<ShortAdminRule> {
    private static final long serialVersionUID = 2987962533487848796L;
    public static final GeoServerDataProvider.Property<ShortAdminRule> PRIORITY = new GeoServerDataProvider.BeanProperty("priority", "priority");
    public static final GeoServerDataProvider.Property<ShortAdminRule> ROLE = new RuleBeanProperty("roleName", "roleName");
    public static final GeoServerDataProvider.Property<ShortAdminRule> USER = new RuleBeanProperty("userName", "userName");
    public static final GeoServerDataProvider.Property<ShortAdminRule> WORKSPACE = new RuleBeanProperty("workspace", "workspace");
    public static final GeoServerDataProvider.Property<ShortAdminRule> ACCESS = new RuleBeanProperty("access", "access");
    public static final GeoServerDataProvider.Property<ShortAdminRule> BUTTONS = new GeoServerDataProvider.PropertyPlaceholder("buttons");
    protected List<ShortAdminRule> rules = GeofenceAdminRulesModel.adminService().getAll();

    private static AdminRuleAdminService adminService() {
        return (AdminRuleAdminService)GeoServerApplication.get().getBean("adminRuleAdminService");
    }

    public GeofenceAdminRulesModel() {
        this.setSort("priority", SortOrder.ASCENDING);
    }

    protected Comparator<ShortAdminRule> getComparator(SortParam<?> sort) {
        return null;
    }

    public void setSort(SortParam<Object> param) {
        super.setSort(param);
        Collections.sort(this.rules, super.getComparator(param));
    }

    protected List<GeoServerDataProvider.Property<ShortAdminRule>> getProperties() {
        return Arrays.asList(PRIORITY, ROLE, USER, WORKSPACE, ACCESS, BUTTONS);
    }

    protected List<ShortAdminRule> getItems() {
        return this.rules;
    }

    public void save(ShortAdminRule rule) {
        if (rule.getId() == null) {
            int i;
            this.shiftIfNecessary(rule.getPriority(), rule);
            for (i = 0; i < this.rules.size() && this.rules.get(i).getPriority() < rule.getPriority(); ++i) {
            }
            this.rules.add(i, rule);
            AdminRule bigRule = new AdminRule();
            GeofenceAdminRulesModel.syncRule(rule, bigRule);
            rule.setId(Long.valueOf(GeofenceAdminRulesModel.adminService().insert(bigRule)));
        } else {
            AdminRule bigRule = GeofenceAdminRulesModel.adminService().get(rule.getId().longValue());
            if (bigRule.getPriority() != rule.getPriority()) {
                this.shiftIfNecessary(rule.getPriority(), rule);
            }
            GeofenceAdminRulesModel.syncRule(rule, bigRule);
            GeofenceAdminRulesModel.adminService().update(bigRule);
        }
    }

    public void remove(Collection<ShortAdminRule> selected) {
        this.rules.removeAll(selected);
        for (ShortAdminRule rule : selected) {
            GeofenceAdminRulesModel.adminService().delete(rule.getId().longValue());
        }
    }

    public boolean canUp(ShortAdminRule rule) {
        return this.rules.indexOf(rule) > 0;
    }

    public void moveUp(ShortAdminRule rule) {
        int index = this.rules.indexOf(rule);
        if (index > 0) {
            this.swap(rule, this.rules.get(index - 1));
            this.rules.remove(index);
            this.rules.add(index - 1, rule);
        }
    }

    public boolean canDown(ShortAdminRule rule) {
        return this.rules.indexOf(rule) < this.rules.size() - 1;
    }

    public void moveDown(ShortAdminRule rule) {
        int index = this.rules.indexOf(rule);
        if (index < this.rules.size() - 1) {
            this.swap(rule, this.rules.get(index + 1));
            this.rules.remove(index);
            this.rules.add(index + 1, rule);
        }
    }

    protected void swap(ShortAdminRule rule, ShortAdminRule otherRule) {
        long p = otherRule.getPriority();
        otherRule.setPriority(rule.getPriority());
        rule.setPriority(p);
        GeofenceAdminRulesModel.adminService().swap(rule.getId().longValue(), otherRule.getId().longValue());
    }

    protected void shiftIfNecessary(long priority, ShortAdminRule keep) {
        boolean necessary = false;
        for (ShortAdminRule rule : this.rules) {
            if (rule.getPriority() != priority) continue;
            necessary = true;
        }
        if (necessary) {
            for (ShortAdminRule rule : this.rules) {
                if (rule.getPriority() < priority || rule == keep) continue;
                rule.setPriority(rule.getPriority() + 1L);
            }
            GeofenceAdminRulesModel.adminService().shift(priority, 1L);
        }
    }

    public ShortAdminRule newRule() {
        ShortAdminRule rule = new ShortAdminRule();
        rule.setAccess(AdminGrantType.USER);
        rule.setPriority(0L);
        return rule;
    }

    protected static void syncRule(ShortAdminRule shortRule, AdminRule rule) {
        rule.setPriority(shortRule.getPriority());
        rule.setUsername(shortRule.getUserName());
        rule.setRolename(shortRule.getRoleName());
        rule.setWorkspace(shortRule.getWorkspace());
        rule.setAccess(shortRule.getAccess());
    }

    public static class RuleBeanProperty<T>
    extends GeoServerDataProvider.BeanProperty<T> {
        private static final long serialVersionUID = 3626448043686728925L;

        public RuleBeanProperty(String key, String propertyPath) {
            super(key, propertyPath);
        }

        public Comparator<T> getComparator() {
            return null;
        }

        public IModel getModel(IModel<T> itemModel) {
            return new PropertyModel<Object>(itemModel, this.getPropertyPath()){
                private static final long serialVersionUID = -3213885135907358752L;

                public Object getObject() {
                    Object o = super.getObject();
                    return o == null ? "*" : o;
                }
            };
        }
    }
}

