/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.integration;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.server.integration.GeofenceWMSTestSupport;
import org.geotools.image.test.ImageAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GeofenceGetMapIntegrationTest
extends GeofenceWMSTestSupport {
    private GeoFenceConfigurationManager configurationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitRuleWithAllowedAreaLayerGroup() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        LayerGroupInfo group = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ANONYMOUS", "WMS", null, null, "lakes_and_places", 0L, this.ruleService);
            String areWKT = "MULTIPOLYGON (((0.0006 -0.0018, 0.001 -0.0006, 0.0024 -0.0001, 0.0031 -0.0015, 0.0006 -0.0018), (0.0017 -0.0011, 0.0025 -0.0011, 0.0025 -0.0006, 0.0017 -0.0006, 0.0017 -0.0011)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId2, CatalogMode.HIDE, areWKT, 4326, this.ruleService);
            group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, "lakes_and_places");
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=" + group.getName() + "&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            BufferedImage image = this.getAsImage(url, "image/png");
            URL expectedResponse = ((Object)((Object)this)).getClass().getResource("layer-group-allowed-area.png");
            BufferedImage expectedImage = ImageIO.read(expectedResponse);
            ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)image, (int)500);
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
        this.removeLayerGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoleOnlyMatch() throws Exception {
        this.configurationManager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager", GeoFenceConfigurationManager.class);
        GeoFenceConfiguration config = this.configurationManager.getConfiguration();
        config.setUseRolesToFilter(true);
        config.getRoles().add("ROLE_USER");
        LayerGroupInfo group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.NAMED, "lakes_and_places");
        Long ruleId1 = null;
        Long ruleId2 = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.DENY, "john", null, "WMS", null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, "jane", null, "WMS", null, null, null, 0L, this.ruleService);
            this.login("john", "", new String[]{"ROLE_USER"});
            String url = "wms?request=getmap&service=wms&layers=Lakes&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertTrue((boolean)resp.getContentAsString().contains("Could not find layer Lakes"));
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            config.setUseRolesToFilter(false);
            config.getRoles().remove("ROLE_USER");
            this.removeLayerGroup(group);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        config.setUseRolesToFilter(false);
        config.getRoles().remove("ROLE_USER");
        this.removeLayerGroup(group);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessWithoutRole() throws Exception {
        this.configurationManager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager", GeoFenceConfigurationManager.class);
        GeoFenceConfiguration config = this.configurationManager.getConfiguration();
        config.setUseRolesToFilter(true);
        LayerGroupInfo group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.NAMED, "lakes_and_places");
        Long ruleId1 = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, "john", null, "WMS", null, null, null, 1L, this.ruleService);
            this.login("john", "", new String[0]);
            String url = "wms?request=getmap&service=wms&layers=Lakes&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertEquals((long)200L, (long)resp.getStatus());
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
            config.setUseRolesToFilter(false);
            this.removeLayerGroup(group);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
        config.setUseRolesToFilter(false);
        this.removeLayerGroup(group);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnyRoleMatch() throws Exception {
        this.configurationManager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager", GeoFenceConfigurationManager.class);
        GeoFenceConfiguration config = this.configurationManager.getConfiguration();
        config.setUseRolesToFilter(true);
        config.getRoles().add("*");
        LayerGroupInfo group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.NAMED, "lakes_and_places");
        Long ruleId1 = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, "ROLE_WMS", null, null, null, null, 0L, this.ruleService);
            this.login("john", "", new String[]{"ROLE_WMS"});
            String url = "wms?request=getmap&service=wms&layers=Lakes&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertEquals((long)200L, (long)resp.getStatus());
            Assert.assertEquals((Object)"image/png", (Object)resp.getContentType());
            this.logout();
            this.login("jane", "", new String[]{"ROLE_USER"});
            MockHttpServletResponse resp2 = this.getAsServletResponse(url);
            Assert.assertEquals((long)200L, (long)resp2.getStatus());
            Assert.assertTrue((boolean)resp2.getContentAsString().contains("Could not find layer Lakes"));
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
            config.setUseRolesToFilter(false);
            config.getRoles().remove("*");
            this.removeLayerGroup(group);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
        config.setUseRolesToFilter(false);
        config.getRoles().remove("*");
        this.removeLayerGroup(group);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDenyRuleOnLayerGroup() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.DENY, null, "ROLE_ANONYMOUS", "WMS", null, null, "containerGroup", 0L, this.ruleService);
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=containerGroup&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertTrue((boolean)resp.getContentAsString().contains("Could not find layer containerGroup"));
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerDirectAccessInOpaqueLayerGroup() throws Exception {
        Long ruleId = null;
        try {
            ruleId = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 0L, this.ruleService);
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            this.setupOpaqueGroup(this.getCatalog());
            LayerGroupInfo group = this.getCatalog().getLayerGroupByName("opaqueGroup");
            for (PublishedInfo pi : group.layers()) {
                String url = "wms?request=getmap&service=wms&layers=" + pi.prefixedName() + "&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
                MockHttpServletResponse resp = this.getAsServletResponse(url);
                Assert.assertTrue((boolean)resp.getContentAsString().contains("Could not find layer " + pi.prefixedName()));
            }
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectAccessLayerWithNamedTreeContainer() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        LayerGroupInfo group = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ANONYMOUS", "WMS", null, null, "lakes_and_places", 0L, this.ruleService);
            String areWKT = "MULTIPOLYGON (((0.0006 -0.0018, 0.001 -0.0006, 0.0024 -0.0001, 0.0031 -0.0015, 0.0006 -0.0018), (0.0017 -0.0011, 0.0025 -0.0011, 0.0025 -0.0006, 0.0017 -0.0006, 0.0017 -0.0011)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId2, CatalogMode.HIDE, areWKT, 4326, this.ruleService);
            group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.NAMED, "lakes_and_places");
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=cite:NamedPlaces&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            BufferedImage image = this.getAsImage(url, "image/png");
            URL expectedResponse = ((Object)((Object)this)).getClass().getResource("places-allowed-area.png");
            BufferedImage expectedImage = ImageIO.read(expectedResponse);
            ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)image, (int)500);
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
        this.removeLayerGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClipAndIntersectSpatialFilters() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        Long ruleId3 = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 999L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ANONYMOUS", "WMS", null, "cite", "BasicPolygons", 20L, this.ruleService);
            String clipWKT = "MultiPolygon (((-2.01345454545454672 5.93445454545454698, -2.00454545454545574 4.30409090909090963, -0.2049090909090916 4.31300000000000061, 1.00672727272727203 5.57809090909091054, 0.97999999999999998 5.98790909090909285, -2.01345454545454672 5.93445454545454698)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId2, CatalogMode.HIDE, clipWKT, 4326, SpatialFilterType.CLIP, this.ruleService);
            ruleId3 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ANONYMOUS2", "WMS", null, "cite", "BasicPolygons", 21L, this.ruleService);
            String intersectsWKT = "MultiPolygon (((-2.41436363636363804 1.47100000000000009, 1.77290909090909077 1.23936363636363645, 1.47890909090909028 -0.40881818181818197, -2.83309090909091044 -0.18609090909090931, -2.41436363636363804 1.47100000000000009)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId3, CatalogMode.HIDE, intersectsWKT, 4326, SpatialFilterType.INTERSECT, this.ruleService);
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS", "ROLE_ANONYMOUS2"});
            String url = "wms?request=getmap&service=wms&layers=cite:BasicPolygons&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-2.0,-1.0,2.0,6.0";
            BufferedImage image = this.getAsImage(url, "image/png");
            URL expectedResponse = ((Object)((Object)this)).getClass().getResource("clip_and_intersects.png");
            BufferedImage expectedImage = ImageIO.read(expectedResponse);
            ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)image, (int)500);
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2, ruleId3);
            this.logout();
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2, ruleId3);
        this.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectAccessLayerWithNonGlobalNamedTreeContainer() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        LayerGroupInfo group = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ANONYMOUS", "WMS", null, null, "lakes_and_places", 0L, this.ruleService);
            String areWKT = "MULTIPOLYGON (((0.0006 -0.0018, 0.001 -0.0006, 0.0024 -0.0001, 0.0031 -0.0015, 0.0006 -0.0018), (0.0017 -0.0011, 0.0025 -0.0011, 0.0025 -0.0006, 0.0017 -0.0006, 0.0017 -0.0011)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId2, CatalogMode.HIDE, areWKT, 4326, this.ruleService);
            WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX);
            group = this.createLakesPlacesLayerGroup(this.getCatalog(), "lakes_and_places", ws, LayerGroupInfo.Mode.NAMED, null);
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=cite:NamedPlaces&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            BufferedImage image = this.getAsImage(url, "image/png");
            URL expectedResponse = ((Object)((Object)this)).getClass().getResource("places-allowed-area.png");
            BufferedImage expectedImage = ImageIO.read(expectedResponse);
            ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)image, (int)500);
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
        this.removeLayerGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGeofenceAccessManagerNotFailsGetMapNestedGroup() throws Exception {
        Long ruleId1 = null;
        LayerGroupInfo group = null;
        LayerGroupInfo nested = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, "nested");
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.OPAQUE_CONTAINER, "container");
            this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
            group = this.getCatalog().getLayerGroupByName("container");
            nested = this.getCatalog().getLayerGroupByName("nested");
            group.getLayers().add(nested);
            group.getStyles().add(null);
            this.getCatalog().save(group);
            this.logout();
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=" + group.getName() + "&styles=&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
            this.logout();
            this.removeLayerGroup(group);
            this.removeLayerGroup(nested);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1);
        this.logout();
        this.removeLayerGroup(group);
        this.removeLayerGroup(nested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupAndStyleRules() throws Exception {
        Long r1 = null;
        Long r2 = null;
        LayerGroupInfo group = null;
        String layerGroupName = "lakes_and_places_style";
        try {
            r1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            r2 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, "ROLE_ANONYMOUS", "WMS", null, "cite", "Forests", 0L, this.ruleService);
            List<String> allowedStyles = Arrays.asList("Lakes", "NamedPlaces");
            GeofenceGetMapIntegrationTest.addLayerDetails(this.ruleService, r2, new HashSet<String>(allowedStyles), Collections.emptySet(), CatalogMode.HIDE, null, null, LayerType.VECTOR);
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, layerGroupName);
            this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
            group = this.getCatalog().getLayerGroupByName(layerGroupName);
            StyleInfo polygonStyle = this.getCatalog().getStyleByName("polygon");
            LayerInfo forest = this.getCatalog().getLayerByName(this.getLayerId(MockData.FORESTS));
            forest.getStyles().add(polygonStyle);
            this.getCatalog().save(forest);
            ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
            styles.add(polygonStyle);
            this.addLayerGroupStyle(group, "forests_style", Arrays.asList(forest), styles);
            this.logout();
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?request=getmap&service=wms&layers=" + group.getName() + "&styles=&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
            url = "wms?request=getmap&service=wms&layers=" + group.getName() + "&styles=forests_style&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"text/xml", (Object)this.getBaseMimeType(response.getContentType()));
            Assert.assertTrue((boolean)response.getContentAsString().contains("style is not available on this layer"));
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, r1, r2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, r1, r2);
        this.logout();
        this.removeLayerGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitAndAllowRuleEnlargementLayerGroup() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        LayerGroupInfo group = null;
        try {
            ruleId1 = GeofenceGetMapIntegrationTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GeofenceGetMapIntegrationTest.addRule(GrantType.LIMIT, null, "ROLE_ONE", "WMS", null, null, "lakes_and_places", 0L, this.ruleService);
            String areWKT = "MULTIPOLYGON (((0.0006 -0.0018, 0.001 -0.0006, 0.0024 -0.0001, 0.0031 -0.0015, 0.0006 -0.0018), (0.0017 -0.0011, 0.0025 -0.0011, 0.0025 -0.0006, 0.0017 -0.0006, 0.0017 -0.0011)))";
            GeofenceGetMapIntegrationTest.addRuleLimits(ruleId2, CatalogMode.HIDE, areWKT, 4326, this.ruleService);
            group = this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, "lakes_and_places");
            this.login("someUser", "", new String[]{"ROLE_ONE", "ROLE_TWO"});
            String url = "wms?request=getmap&service=wms&layers=" + group.getName() + "&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
            BufferedImage image = this.getAsImage(url, "image/png");
            URL expectedResponse = ((Object)((Object)this)).getClass().getResource("lakes_and_places_full.png");
            BufferedImage expectedImage = ImageIO.read(expectedResponse);
            ImageAssert.assertEquals((RenderedImage)image, (RenderedImage)expectedImage, (int)500);
        }
        catch (Throwable throwable) {
            GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GeofenceGetMapIntegrationTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
        this.removeLayerGroup(group);
    }
}

