/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import org.geoserver.config.util.CollectionConverter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.geofence.server.rest.xml.Batch;
import org.geoserver.geofence.server.rest.xml.BatchOperation;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRuleList;
import org.geoserver.geofence.server.rest.xml.JaxbRule;
import org.geoserver.geofence.server.rest.xml.JaxbRuleList;
import org.geoserver.geofence.server.rest.xml.MultiPolygonAdapter;
import org.geoserver.geofence.server.xstream.BatchOpXtreamConverter;

public class GeoFenceServerXStreamInitializer
implements XStreamPersisterInitializer {
    public void init(XStreamPersister persister) {
        XStream xs = persister.getXStream();
        xs.alias("Rule", JaxbRule.class);
        xs.alias("AdminRule", JaxbAdminRule.class);
        xs.alias("Rules", JaxbRuleList.class);
        xs.alias("AdminRules", JaxbAdminRuleList.class);
        xs.alias("Batch", Batch.class);
        xs.alias("BatchOperation", BatchOperation.class);
        xs.registerLocalConverter(Batch.class, "operations", (Converter)new CollectionConverter(xs.getMapper()));
        xs.addImplicitCollection(Batch.class, "operations", BatchOperation.class);
        xs.registerConverter((Converter)new BatchOpXtreamConverter(xs.getMapper(), xs.getReflectionProvider()));
        xs.allowTypes(new Class[]{JaxbRule.class, JaxbAdminRule.class, JaxbRuleList.class, JaxbAdminRuleList.class, MultiPolygonAdapter.class, JaxbRule.Limits.class, JaxbRule.LayerDetails.class, JaxbRule.LayerAttribute.class, Batch.class, BatchOperation.class});
    }
}

