/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest.xml;

import java.sql.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geoserver.geofence.core.model.IPAddressRange;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.AccessType;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.server.rest.xml.AbstractPayload;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

@XmlRootElement(name="Rule")
public class JaxbRule
extends AbstractPayload {
    private Long id;
    private Long priority;
    private String userName;
    private String roleName;
    private String addressRange;
    private String validAfter;
    private String validBefore;
    private String workspace;
    private String layer;
    private String service;
    private String request;
    private String subfield;
    private String access;
    private Limits limits;
    private LayerDetails layerDetails;

    public JaxbRule() {
    }

    public JaxbRule(Rule rule) {
        this.id = rule.getId();
        this.priority = rule.getPriority();
        this.userName = rule.getUsername();
        this.roleName = rule.getRolename();
        this.addressRange = rule.getAddressRangeString();
        this.validAfter = rule.getValidAfterString();
        this.validBefore = rule.getValidBeforeString();
        this.workspace = rule.getWorkspace();
        this.layer = rule.getLayer();
        this.service = rule.getService() == null ? null : rule.getService().toUpperCase();
        this.request = rule.getRequest();
        this.subfield = rule.getSubfield();
        this.access = rule.getAccess().toString();
        if (rule.getRuleLimits() != null) {
            this.limits = new Limits();
            this.limits.setAllowedArea(rule.getRuleLimits().getAllowedArea());
            if (rule.getRuleLimits().getCatalogMode() != null) {
                this.limits.setCatalogMode(rule.getRuleLimits().getCatalogMode().toString());
            } else {
                this.limits.setCatalogMode(null);
            }
            SpatialFilterType spatialFilterType = rule.getRuleLimits().getSpatialFilterType();
            if (spatialFilterType != null) {
                this.limits.setSpatialFilterType(spatialFilterType.toString());
            } else {
                this.limits.setSpatialFilterType(null);
            }
        }
        if (rule.getLayerDetails() != null) {
            org.geoserver.geofence.core.model.LayerDetails otherDetails = rule.getLayerDetails();
            this.layerDetails = new LayerDetails();
            this.layerDetails.setAllowedArea(otherDetails.getArea());
            this.layerDetails.getAllowedStyles().addAll(otherDetails.getAllowedStyles());
            SpatialFilterType spatialFilterType = otherDetails.getSpatialFilterType();
            if (spatialFilterType != null) {
                this.layerDetails.setSpatialFilterType(spatialFilterType.toString());
            } else {
                this.layerDetails.setSpatialFilterType(null);
            }
            if (otherDetails.getCatalogMode() != null) {
                this.layerDetails.setCatalogMode(otherDetails.getCatalogMode().toString());
            } else {
                this.layerDetails.setCatalogMode(null);
            }
            this.layerDetails.setCqlFilterRead(otherDetails.getCqlFilterRead());
            this.layerDetails.setCqlFilterWrite(otherDetails.getCqlFilterWrite());
            this.layerDetails.setDefaultStyle(otherDetails.getDefaultStyle());
            if (otherDetails.getType() != null) {
                this.layerDetails.setLayerType(otherDetails.getType().toString());
            }
            for (org.geoserver.geofence.core.model.LayerAttribute att : otherDetails.getAttributes()) {
                this.layerDetails.getAttributes().add(new LayerAttribute(att));
            }
        }
    }

    @XmlAttribute
    public Long getId() {
        return this.id;
    }

    @XmlElement
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @XmlElement
    public String getUserName() {
        return JaxbRule.convertAny(this.userName);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @XmlElement
    public String getRoleName() {
        return JaxbRule.convertAny(this.roleName);
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAddressRange() {
        return JaxbRule.convertAny(this.addressRange);
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    @XmlElement
    public String getValidAfter() {
        return this.validAfter;
    }

    public void setValidAfter(String validAfter) {
        this.validAfter = validAfter;
    }

    @XmlElement
    public String getValidBefore() {
        return this.validBefore;
    }

    public void setValidBefore(String validBefore) {
        this.validBefore = validBefore;
    }

    @XmlElement
    public String getWorkspace() {
        return JaxbRule.convertAny(this.workspace);
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @XmlElement
    public String getLayer() {
        return JaxbRule.convertAny(this.layer);
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    @XmlElement
    public String getService() {
        return JaxbRule.convertAny(this.service);
    }

    public void setService(String service) {
        this.service = service;
    }

    @XmlElement
    public String getRequest() {
        return JaxbRule.convertAny(this.request);
    }

    public void setRequest(String request) {
        this.request = request;
    }

    @XmlElement
    public String getSubfield() {
        return this.subfield;
    }

    public void setSubfield(String subfield) {
        this.subfield = subfield;
    }

    @XmlElement
    public String getAccess() {
        return JaxbRule.convertAny(this.access);
    }

    public void setAccess(String access) {
        this.access = access;
    }

    @XmlElement
    public Limits getLimits() {
        return this.limits;
    }

    public void setLimits(Limits limits) {
        this.limits = limits;
    }

    public LayerDetails getLayerDetails() {
        return this.layerDetails;
    }

    public void setLayerDetails(LayerDetails layerDetails) {
        this.layerDetails = layerDetails;
    }

    public Rule toRule() {
        Rule rule = new Rule();
        if (this.getPriority() != null) {
            rule.setPriority(this.getPriority().longValue());
        }
        rule.setAccess(GrantType.valueOf((String)this.getAccess()));
        rule.setUsername(this.getUserName());
        rule.setRolename(this.getRoleName());
        rule.setAddressRange(this.getAddressRange() != null ? new IPAddressRange(this.getAddressRange()) : null);
        rule.setValidAfter(this.getValidAfter() != null ? Date.valueOf(this.getValidAfter()) : null);
        rule.setValidBefore(this.getValidBefore() != null ? Date.valueOf(this.getValidBefore()) : null);
        rule.setService(this.getService());
        rule.setRequest(this.getRequest());
        rule.setSubfield(this.getSubfield());
        rule.setWorkspace(this.getWorkspace());
        rule.setLayer(this.getLayer());
        rule.setId(this.id);
        return rule;
    }

    public Rule toRule(Rule rule) {
        if (this.getPriority() != null) {
            rule.setPriority(this.getPriority().longValue());
        }
        if (this.getAccess() != null) {
            rule.setAccess(GrantType.valueOf((String)this.getAccess()));
        }
        if (this.getUserName() != null) {
            rule.setUsername(JaxbRule.convertAny(this.getUserName()));
        }
        if (this.getRoleName() != null) {
            rule.setRolename(JaxbRule.convertAny(this.getRoleName()));
        }
        if (this.getAddressRange() != null) {
            rule.setAddressRange(new IPAddressRange(this.getAddressRange()));
        }
        if (this.getValidAfter() != null) {
            rule.setValidAfter(Date.valueOf(this.getValidAfter()));
        }
        if (this.getValidBefore() != null) {
            rule.setValidBefore(Date.valueOf(this.getValidBefore()));
        }
        if (this.getService() != null) {
            rule.setService(JaxbRule.convertAny(this.getService()));
        }
        if (this.getRequest() != null) {
            rule.setRequest(JaxbRule.convertAny(this.getRequest()));
        }
        if (this.getSubfield() != null) {
            rule.setSubfield(JaxbRule.convertAny(this.getSubfield()));
        }
        if (this.getWorkspace() != null) {
            rule.setWorkspace(JaxbRule.convertAny(this.getWorkspace()));
        }
        if (this.getLayer() != null) {
            rule.setLayer(JaxbRule.convertAny(this.getLayer()));
        }
        if (this.id != null) {
            rule.setId(this.id);
        }
        return rule;
    }

    protected static String convertAny(String s) {
        if (s == null || "null".equals(s) || "".equals(s) || "*".equals(s)) {
            return null;
        }
        return s;
    }

    public static class LayerDetails {
        private String layerType;
        private String defaultStyle;
        private String cqlFilterRead;
        private String cqlFilterWrite;
        private String allowedArea;
        private String spatialFilterType;
        private String catalogMode;
        private Set<String> allowedStyles = new HashSet<String>();
        private Set<LayerAttribute> layerAttributes = new HashSet<LayerAttribute>();

        @XmlElement
        public String getLayerType() {
            return JaxbRule.convertAny(this.layerType);
        }

        public void setLayerType(String layerType) {
            this.layerType = layerType;
        }

        @XmlElement
        public String getDefaultStyle() {
            return JaxbRule.convertAny(this.defaultStyle);
        }

        public void setDefaultStyle(String defaultStyle) {
            this.defaultStyle = defaultStyle;
        }

        @XmlElement
        public String getCqlFilterRead() {
            return JaxbRule.convertAny(this.cqlFilterRead);
        }

        public void setCqlFilterRead(String cqlFilterRead) {
            this.cqlFilterRead = cqlFilterRead;
        }

        @XmlElement
        public String getCqlFilterWrite() {
            return JaxbRule.convertAny(this.cqlFilterWrite);
        }

        public void setCqlFilterWrite(String cqlFilterWrite) {
            this.cqlFilterWrite = cqlFilterWrite;
        }

        @XmlElement
        public String getAllowedArea() {
            return JaxbRule.convertAny(this.allowedArea);
        }

        public void setAllowedArea(MultiPolygon allowedArea) {
            String strAllowedArea = null;
            if (allowedArea != null) {
                int srid = allowedArea.getSRID();
                String wktSRID = "SRID=" + (srid == 0 ? "4326" : String.valueOf(srid));
                strAllowedArea = wktSRID + ";" + allowedArea.toText();
            }
            this.allowedArea = strAllowedArea;
        }

        @XmlElement
        public String getSpatialFilterType() {
            return JaxbRule.convertAny(this.spatialFilterType);
        }

        public void setSpatialFilterType(String spatialFilterType) {
            this.spatialFilterType = spatialFilterType;
        }

        @XmlElement
        public String getCatalogMode() {
            return JaxbRule.convertAny(this.catalogMode);
        }

        public void setCatalogMode(String catalogMode) {
            this.catalogMode = catalogMode;
        }

        @XmlElement(name="allowedStyle")
        public Set<String> getAllowedStyles() {
            return this.allowedStyles;
        }

        public void setAllowedStyles(Set<String> allowedStyles) {
            this.allowedStyles = allowedStyles;
        }

        @XmlElement(name="attribute")
        public Set<LayerAttribute> getAttributes() {
            return this.layerAttributes;
        }

        public void setAttributes(Set<LayerAttribute> layerAttributes) {
            this.layerAttributes = layerAttributes;
        }

        public org.geoserver.geofence.core.model.LayerDetails toLayerDetails(org.geoserver.geofence.core.model.LayerDetails details) {
            details = new org.geoserver.geofence.core.model.LayerDetails();
            if (JaxbRule.convertAny(this.layerType) != null) {
                details.setType(LayerType.valueOf((String)this.layerType.toUpperCase()));
            }
            if (this.allowedStyles != null) {
                details.getAllowedStyles().addAll(this.allowedStyles);
            }
            if (JaxbRule.convertAny(this.allowedArea) != null) {
                try {
                    String areaWKT = this.getAllowedArea();
                    int areaSRID = -1;
                    if (this.getAllowedArea().startsWith("SRID")) {
                        areaWKT = this.getAllowedArea().split(";")[1];
                        areaSRID = Integer.parseInt(this.getAllowedArea().split(";")[0].split("=")[1]);
                    }
                    MultiPolygon area = (MultiPolygon)new WKTReader().read(areaWKT);
                    area.setSRID(areaSRID);
                    details.setArea(area);
                }
                catch (ParseException e) {
                    details.setArea(null);
                }
            }
            if (this.layerAttributes != null) {
                for (LayerAttribute att : this.layerAttributes) {
                    Iterator it = details.getAttributes().iterator();
                    while (it.hasNext()) {
                        if (!((org.geoserver.geofence.core.model.LayerAttribute)it.next()).getName().equals(att.getName())) continue;
                        it.remove();
                        break;
                    }
                    details.getAttributes().add(att.toLayerAttribute());
                }
            }
            if (JaxbRule.convertAny(this.catalogMode) != null) {
                details.setCatalogMode(CatalogMode.valueOf((String)this.catalogMode.toUpperCase()));
            }
            if (JaxbRule.convertAny(this.cqlFilterRead) != null) {
                details.setCqlFilterRead(this.cqlFilterRead);
            }
            if (JaxbRule.convertAny(this.cqlFilterWrite) != null) {
                details.setCqlFilterWrite(this.cqlFilterWrite);
            }
            if (JaxbRule.convertAny(this.defaultStyle) != null) {
                details.setDefaultStyle(this.defaultStyle);
            }
            if (JaxbRule.convertAny(this.spatialFilterType) != null) {
                details.setSpatialFilterType(SpatialFilterType.valueOf((String)this.spatialFilterType));
            }
            return details;
        }
    }

    public static class LayerAttribute {
        private String name;
        private String dataType;
        private String accessType;

        public LayerAttribute() {
        }

        public LayerAttribute(org.geoserver.geofence.core.model.LayerAttribute att) {
            this.name = att.getName();
            this.dataType = att.getDatatype();
            this.accessType = att.getAccess().toString();
        }

        @XmlElement
        public String getName() {
            return JaxbRule.convertAny(this.name);
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getDataType() {
            return JaxbRule.convertAny(this.dataType);
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @XmlElement
        public String getAccessType() {
            return JaxbRule.convertAny(this.accessType);
        }

        public void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public org.geoserver.geofence.core.model.LayerAttribute toLayerAttribute() {
            org.geoserver.geofence.core.model.LayerAttribute att = new org.geoserver.geofence.core.model.LayerAttribute();
            if (JaxbRule.convertAny(this.accessType) != null) {
                att.setAccess(AccessType.valueOf((String)this.accessType.toUpperCase()));
            }
            att.setDatatype(JaxbRule.convertAny(this.dataType));
            att.setName(JaxbRule.convertAny(this.name));
            return att;
        }
    }

    public static class Limits {
        private String allowedArea;
        private String catalogMode;
        private String spatialFilterType;

        @XmlElement
        public String getAllowedArea() {
            return JaxbRule.convertAny(this.allowedArea);
        }

        public void setAllowedArea(MultiPolygon allowedArea) {
            if (allowedArea != null) {
                int srid = allowedArea.getSRID();
                String wktSRID = "SRID=" + (srid == 0 ? "4326" : String.valueOf(srid));
                this.allowedArea = wktSRID + ";" + allowedArea.toText();
            }
        }

        @XmlElement
        public String getCatalogMode() {
            return JaxbRule.convertAny(this.catalogMode);
        }

        public void setCatalogMode(String catalogMode) {
            this.catalogMode = catalogMode;
        }

        @XmlElement
        public String getSpatialFilterType() {
            return JaxbRule.convertAny(this.spatialFilterType);
        }

        public void setSpatialFilterType(String spatialFilterType) {
            this.spatialFilterType = spatialFilterType;
        }

        public RuleLimits toRuleLimits(RuleLimits ruleLimits) {
            if (ruleLimits == null) {
                ruleLimits = new RuleLimits();
            }
            if (this.getAllowedArea() != null) {
                try {
                    String areaWKT = this.getAllowedArea();
                    int areaSRID = -1;
                    if (this.getAllowedArea().startsWith("SRID")) {
                        areaWKT = this.getAllowedArea().split(";")[1];
                        areaSRID = Integer.parseInt(this.getAllowedArea().split(";")[0].split("=")[1]);
                    }
                    MultiPolygon area = (MultiPolygon)new WKTReader().read(areaWKT);
                    area.setSRID(areaSRID);
                    ruleLimits.setAllowedArea(area);
                }
                catch (ParseException e) {
                    ruleLimits.setAllowedArea(null);
                }
            }
            if (this.getCatalogMode() != null) {
                ruleLimits.setCatalogMode(CatalogMode.valueOf((String)this.getCatalogMode().toUpperCase()));
            }
            if (this.getSpatialFilterType() != null) {
                ruleLimits.setSpatialFilterType(SpatialFilterType.valueOf((String)this.getSpatialFilterType()));
            }
            return ruleLimits;
        }
    }
}

