/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest.xml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.IPAddressRange;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.server.rest.xml.AbstractPayload;

@XmlRootElement(name="AdminRule")
public class JaxbAdminRule
extends AbstractPayload {
    private Long id;
    private Long priority;
    private String userName;
    private String roleName;
    private String addressRange;
    private String workspace;
    private String access;

    public JaxbAdminRule() {
    }

    public JaxbAdminRule(AdminRule rule) {
        this.id = rule.getId();
        this.priority = rule.getPriority();
        this.userName = rule.getUsername();
        this.roleName = rule.getRolename();
        this.addressRange = rule.getAddressRange() == null ? null : rule.getAddressRange().getCidrSignature();
        this.workspace = rule.getWorkspace();
        this.access = rule.getAccess().toString();
    }

    @XmlAttribute
    public Long getId() {
        return this.id;
    }

    @XmlElement
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @XmlElement
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @XmlElement
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    @XmlElement
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    @XmlElement
    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public AdminRule toRule() {
        AdminRule rule = new AdminRule();
        if (this.getPriority() != null) {
            rule.setPriority(this.getPriority().longValue());
        }
        rule.setAccess(AdminGrantType.valueOf((String)this.getAccess()));
        rule.setUsername(this.getUserName());
        rule.setRolename(this.getRoleName());
        rule.setAddressRange(this.getAddressRange() == null ? null : new IPAddressRange(this.getAddressRange()));
        rule.setWorkspace(this.getWorkspace());
        rule.setId(this.id);
        return rule;
    }

    public AdminRule toRule(AdminRule rule) {
        if (this.getPriority() != null) {
            rule.setPriority(this.getPriority().longValue());
        }
        if (this.getAccess() != null) {
            rule.setAccess(AdminGrantType.valueOf((String)this.getAccess()));
        }
        if (this.getUserName() != null) {
            rule.setUsername(JaxbAdminRule.convertAny(this.getUserName()));
        }
        if (this.getRoleName() != null) {
            rule.setRolename(JaxbAdminRule.convertAny(this.getRoleName()));
        }
        if (this.getAddressRange() != null) {
            rule.setAddressRange(new IPAddressRange(this.getAddressRange()));
        }
        if (this.getWorkspace() != null) {
            rule.setWorkspace(JaxbAdminRule.convertAny(this.getWorkspace()));
        }
        if (this.id != null) {
            rule.setId(this.id);
        }
        return rule;
    }

    protected static String convertAny(String s) {
        if ("".equals(s) || "*".equals(s)) {
            return null;
        }
        return s;
    }
}

