/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.geofence.spi.UserResolver;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Deprecated
@PropertySource(value={"classpath*:application.properties"})
public class InternalUserResolver
implements UserResolver {
    public static final String DEFAULT_USER_GROUP_SERVICE_KEY = "org.geoserver.rest.DefaultUserGroupServiceName";
    private Logger logger = Logging.getLogger(InternalUserResolver.class);
    @Autowired
    private Environment env;
    @Value(value="${org.geoserver.rest.DefaultUserGroupServiceName}")
    private String DEFAULT_ROLE_SERVICE_NAME;
    private GeoServerSecurityService defaultSecurityService;
    protected GeoServerSecurityManager securityManager;

    private String getDefaultServiceName() {
        String defaultServiceName = System.getProperty(DEFAULT_USER_GROUP_SERVICE_KEY);
        if (defaultServiceName != null) {
            return defaultServiceName;
        }
        defaultServiceName = defaultServiceName == null ? this.env.getProperty(DEFAULT_USER_GROUP_SERVICE_KEY) : this.DEFAULT_ROLE_SERVICE_NAME;
        return defaultServiceName == null ? this.DEFAULT_ROLE_SERVICE_NAME : defaultServiceName;
    }

    public GeoServerSecurityService getDefaultSecurityService() throws IOException {
        if (this.defaultSecurityService != null) {
            return this.defaultSecurityService;
        }
        for (String serviceName : this.securityManager.listUserGroupServices()) {
            if (!serviceName.equals(this.getDefaultServiceName())) continue;
            GeoServerUserGroupService userGroupService = this.securityManager.loadUserGroupService(serviceName);
            this.defaultSecurityService = userGroupService;
            return userGroupService;
        }
        for (String roleServiceName : this.securityManager.listRoleServices()) {
            if (!roleServiceName.equals(this.getDefaultServiceName())) continue;
            GeoServerRoleService roleService = this.securityManager.loadRoleService(roleServiceName);
            this.defaultSecurityService = roleService;
            return roleService;
        }
        this.defaultSecurityService = this.securityManager.getActiveRoleService();
        return this.defaultSecurityService;
    }

    public InternalUserResolver(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean existsUser(String username) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Getting Roles for User [" + username + "]");
        }
        try {
            for (String serviceName : this.securityManager.listUserGroupServices()) {
                GeoServerUserGroupService userGroupService;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Checking UserGroupService [" + serviceName + "]");
                }
                if ((userGroupService = this.securityManager.loadUserGroupService(serviceName)).getUserByUsername(username) == null) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "UserGroupService [" + serviceName + "] matching for User [" + username + "]");
                }
                return true;
            }
            for (String roleServiceName : this.securityManager.listRoleServices()) {
                GeoServerRoleService roleService;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Checking RoleService [" + roleServiceName + "]");
                }
                if ((roleService = this.securityManager.loadRoleService(roleServiceName)).getRolesForUser(username) == null || roleService.getRolesForUser(username).isEmpty()) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "RoleService [" + roleServiceName + "] matching for User [" + username + "]");
                }
                return true;
            }
            for (String roleServiceName : this.securityManager.listRoleServices()) {
                SortedSet userRoles = this.securityManager.loadRoleService(roleServiceName).getRolesForUser(username);
                if (userRoles == null || userRoles.isEmpty()) continue;
                return true;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        this.logger.log(Level.FINER, "GeoFence was not able to find any matching user on Security Context or Services.");
        return false;
    }

    public boolean existsRole(String rolename) {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Checking Role [" + rolename + "] on ActiveRoleService [" + this.getDefaultSecurityService() + "]");
            }
            if (this.getDefaultSecurityService() instanceof GeoServerRoleService && ((GeoServerRoleService)this.getDefaultSecurityService()).getRoleByName(rolename) != null) {
                return true;
            }
            return this.securityManager.getActiveRoleService().getRoleByName(rolename) != null;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    public Set<String> getRoles(String username) {
        try {
            SortedSet roleSet = new TreeSet();
            TreeSet<String> stringSet = new TreeSet<String>();
            if (this.getDefaultSecurityService() instanceof GeoServerRoleService) {
                roleSet = ((GeoServerRoleService)this.getDefaultSecurityService()).getRolesForUser(username);
            }
            for (GeoServerRole role : roleSet) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Checking Role [" + role + "] on ActiveRoleService [" + this.getDefaultSecurityService() + "]");
                }
                stringSet.add(role.getAuthority());
            }
            roleSet = this.securityManager.getActiveRoleService().getRolesForUser(username);
            for (GeoServerRole role : roleSet) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Checking Role [" + role + "] on ActiveRoleService [" + this.securityManager.getActiveRoleService() + "]");
                }
                stringSet.add(role.getAuthority());
            }
            try {
                for (String serviceName : this.securityManager.listUserGroupServices()) {
                    GeoServerUserGroupService userGroupService;
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Checking UserGroupService [" + serviceName + "]");
                    }
                    if ((userGroupService = this.securityManager.loadUserGroupService(serviceName)).getUserByUsername(username) == null) continue;
                    RoleCalculator calc = null;
                    if (this.getDefaultSecurityService() instanceof GeoServerRoleService) {
                        calc = new RoleCalculator(userGroupService, (GeoServerRoleService)this.getDefaultSecurityService());
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "UserGroupService [" + serviceName + "] matching for User [" + username + "]");
                    }
                    GeoServerUser user = userGroupService.getUserByUsername(username);
                    if (calc != null) {
                        for (GeoServerUserGroup group : userGroupService.getGroupsForUser(user)) {
                            if (!group.isEnabled()) continue;
                            for (GeoServerRole role : calc.calculateRoles(group)) {
                                stringSet.add(role.getAuthority());
                            }
                        }
                    }
                    if ((calc = new RoleCalculator(userGroupService, this.securityManager.getActiveRoleService())) == null) continue;
                    for (GeoServerUserGroup group : userGroupService.getGroupsForUser(user)) {
                        if (!group.isEnabled()) continue;
                        for (GeoServerRole role : calc.calculateRoles(group)) {
                            stringSet.add(role.getAuthority());
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Matching Roles [" + stringSet + "] for User [" + username + "]");
            }
            return stringSet;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return Collections.emptySet();
        }
    }
}

