/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.xstream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.server.rest.xml.Batch;
import org.geoserver.geofence.server.rest.xml.BatchOperation;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbRule;
import org.geoserver.geofence.server.rest.xml.JaxbRuleList;
import org.geoserver.geofence.server.xstream.GeoFenceServerXStreamInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;

public class GeofencePersisterSerializationTest {
    private XStreamPersister xmlPersister;
    private XStreamPersister jsonPersister;

    @Before
    public void setup() {
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        GeoFenceServerXStreamInitializer initializer = new GeoFenceServerXStreamInitializer();
        xpf.addInitializer((XStreamPersisterInitializer)initializer);
        this.xmlPersister = xpf.createXMLPersister();
        this.jsonPersister = xpf.createJSONPersister();
    }

    @Test
    public void testDeserialization() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Rule><access>LIMIT</access><layer>DE_USNG_UTM18</layer><limits>     <allowedArea>SRID=4326;MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))</allowedArea>     <catalogMode>HIDDEN</catalogMode></limits><priority>1</priority><workspace>geonode</workspace></Rule>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        JaxbRule rule = (JaxbRule)this.xmlPersister.load((InputStream)bais, JaxbRule.class);
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"LIMIT", (Object)rule.getAccess());
        Assert.assertEquals((Object)"DE_USNG_UTM18", (Object)rule.getLayer());
        Assert.assertEquals((Object)"geonode", (Object)rule.getWorkspace());
        Assert.assertEquals((long)1L, (long)rule.getPriority().intValue());
        Assert.assertNotNull((Object)rule.getLimits());
        Assert.assertEquals((Object)"SRID=4326;MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))", (Object)rule.getLimits().getAllowedArea());
        Assert.assertEquals((Object)"HIDDEN", (Object)rule.getLimits().getCatalogMode());
    }

    @Test
    public void testSerialization() throws Exception {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(1L));
        rule.setUserName("pippo");
        rule.setRoleName("clown");
        rule.setAddressRange("127.0.0.1/32");
        rule.setService("wfs");
        rule.setRequest("getFeature");
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        JaxbRule.Limits limits = new JaxbRule.Limits();
        limits.setCatalogMode("HIDDEN");
        WKTReader reader = new WKTReader();
        limits.setAllowedArea((MultiPolygon)reader.read("MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))"));
        rule.setLimits(limits);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.xmlPersister.save((Object)rule, (OutputStream)baos);
        baos.flush();
        String xml = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)xml.contains("pippo"));
        Assert.assertTrue((boolean)xml.contains("clown"));
        Assert.assertTrue((boolean)xml.contains("HIDDEN"));
        Assert.assertTrue((boolean)xml.contains("MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))"));
        Rule rule2 = new Rule();
        rule2.setPriority(2L);
        rule2.setUsername("topolino");
        rule2.setRolename("minnie");
        rule2.setService("wfs");
        rule2.setRequest("getFeature");
        rule2.setWorkspace("workspace");
        rule2.setLayer("layer");
        rule2.setAccess(GrantType.ALLOW);
        Rule[] rules = new Rule[]{rule2};
        JaxbRuleList ruleList = new JaxbRuleList(Arrays.asList(rules));
        this.xmlPersister.save((Object)ruleList, (OutputStream)baos);
        baos.flush();
        xml = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)xml.contains("topolino"));
        Assert.assertTrue((boolean)xml.contains("minnie"));
    }

    @Test
    public void testJSONBatchDeserialization() throws IOException {
        Batch batch = (Batch)this.jsonPersister.load(this.getClass().getResourceAsStream("batch.json"), Batch.class);
        this.assertBatch(batch);
    }

    @Test
    public void testBatchXmlDeserialization() throws IOException {
        Batch batch = (Batch)this.xmlPersister.load(this.getClass().getResourceAsStream("batch.xml"), Batch.class);
        this.assertBatch(batch);
    }

    private void assertBatch(Batch batch) {
        List operations = batch.getOperations();
        Assert.assertEquals((long)3L, (long)operations.size());
        block4: for (BatchOperation op : operations) {
            switch (op.getType()) {
                case update: {
                    Assert.assertEquals((Object)BatchOperation.ServiceName.rules, (Object)op.getService());
                    Assert.assertEquals((long)3L, (long)op.getId());
                    JaxbRule rule = (JaxbRule)op.getPayload();
                    Assert.assertEquals((Object)"ALLOW", (Object)rule.getAccess());
                    Assert.assertEquals((Object)"layer", (Object)rule.getLayer());
                    Assert.assertEquals((long)5L, (long)rule.getPriority());
                    Assert.assertEquals((Object)"GETMAP", (Object)rule.getRequest());
                    Assert.assertEquals((Object)"WMS", (Object)rule.getService());
                    Assert.assertEquals((Object)"ws", (Object)rule.getWorkspace());
                    Assert.assertEquals((Object)"ROLE_AUTHENTICATED", (Object)rule.getRoleName());
                    continue block4;
                }
                case delete: {
                    Assert.assertEquals((Object)BatchOperation.ServiceName.rules, (Object)op.getService());
                    Assert.assertEquals((long)5L, (long)op.getId());
                    continue block4;
                }
            }
            Assert.assertEquals((Object)BatchOperation.TypeName.insert, (Object)op.getType());
            Assert.assertEquals((Object)BatchOperation.ServiceName.adminrules, (Object)op.getService());
            JaxbAdminRule adminRule = (JaxbAdminRule)op.getPayload();
            Assert.assertEquals((Object)"ADMIN", (Object)adminRule.getAccess());
            Assert.assertEquals((Object)"ROLE_USER", (Object)adminRule.getRoleName());
            Assert.assertEquals((Object)"ws", (Object)adminRule.getWorkspace());
            Assert.assertEquals((long)2L, (long)adminRule.getPriority());
        }
    }
}

