/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.util.logging.Level;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.config.GeoFencePropertyPlaceholderConfigurer;
import org.geoserver.geofence.server.web.GeofenceAdminRulePage;
import org.geoserver.geofence.server.web.GeofenceServerAdminPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeofenceServerAdminPageTest
extends GeoServerWicketTestSupport {
    static GeoFencePropertyPlaceholderConfigurer configurer;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void before() {
        this.login();
        tester.startPage(GeofenceServerAdminPage.class);
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        GeofenceServerAdminPageTest.testData = new SystemTestData();
        try {
            if (System.getProperty("IS_GEOFENCE_AVAILABLE") != null) {
                System.clearProperty("IS_GEOFENCE_AVAILABLE");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not remove System ENV variable {IS_GEOFENCE_AVAILABLE}", e);
        }
    }

    @Test
    public void testAddNewRuleLink() {
        tester.assertRenderedPage(GeofenceServerAdminPage.class);
        tester.assertComponent("addNew", AjaxLink.class);
        tester.clickLink("addNew");
        tester.assertRenderedPage(GeofenceAdminRulePage.class);
        FormTester form = tester.newFormTester("form");
        form.submit("save");
        tester.assertRenderedPage(GeofenceServerAdminPage.class);
        GeoServerTablePanel rulesPanel = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("rulesPanel");
        Assert.assertEquals((long)1L, (long)rulesPanel.getDataProvider().size());
    }
}

