/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.util.Arrays;
import java.util.logging.Level;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.server.web.GeofenceRulesModel;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class GeofenceRulesModelTest
extends GeoServerWicketTestSupport {
    protected void onTearDown(SystemTestData testData) throws Exception {
        GeofenceRulesModelTest.testData = new SystemTestData();
        try {
            if (System.getProperty("IS_GEOFENCE_AVAILABLE") != null) {
                System.clearProperty("IS_GEOFENCE_AVAILABLE");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not remove System ENV variable {IS_GEOFENCE_AVAILABLE}", e);
        }
    }

    @Test
    public void testRulesModel() {
        GeofenceRulesModel model = new GeofenceRulesModel();
        ShortRule rule1 = model.newRule();
        rule1.setUserName("pipo");
        model.save(rule1);
        ShortRule rule2 = model.newRule();
        rule2.setUserName("jantje");
        model.save(rule2);
        ShortRule rule3 = model.newRule();
        rule3.setUserName("oen");
        model.save(rule3);
        Assert.assertEquals((long)3L, (long)model.getItems().size());
        Assert.assertEquals((Object)rule1, model.getItems().get(2));
        Assert.assertEquals((Object)rule2, model.getItems().get(1));
        Assert.assertEquals((Object)rule3, model.getItems().get(0));
        Assert.assertEquals((long)0L, (long)rule3.getPriority());
        Assert.assertEquals((long)1L, (long)rule2.getPriority());
        Assert.assertEquals((long)2L, (long)rule1.getPriority());
        this.assertSynchronized(model);
        Assert.assertFalse((boolean)model.canDown(rule1));
        Assert.assertFalse((boolean)model.canUp(rule3));
        Assert.assertTrue((boolean)model.canDown(rule2));
        Assert.assertTrue((boolean)model.canUp(rule2));
        model.moveDown(rule2);
        model.moveUp(rule3);
        Assert.assertEquals((Object)rule3, model.getItems().get(0));
        Assert.assertEquals((Object)rule1, model.getItems().get(1));
        Assert.assertEquals((Object)rule2, model.getItems().get(2));
        Assert.assertEquals((long)0L, (long)rule3.getPriority());
        Assert.assertEquals((long)1L, (long)rule1.getPriority());
        Assert.assertEquals((long)2L, (long)rule2.getPriority());
        rule2.setService("WFS");
        model.save(rule2);
        model.remove(Arrays.asList(rule1, rule3));
        Assert.assertEquals((long)1L, (long)model.getItems().size());
        this.assertSynchronized(model);
    }

    public void assertSynchronized(GeofenceRulesModel model) {
        GeofenceRulesModel freshModel = new GeofenceRulesModel();
        Assert.assertEquals((Object)model.getItems().toString(), (Object)freshModel.getItems().toString());
    }
}

