/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.internal;

import java.util.Collections;
import org.geoserver.geofence.server.internal.SecurityContextUserResolver;
import org.geoserver.security.impl.GeoServerRole;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextUserResolverTest {
    @Test
    public void existsUser() {
        SecurityContextUserResolver securityContextUserResolver = new SecurityContextUserResolver();
        Assert.assertThrows(IllegalStateException.class, () -> securityContextUserResolver.existsUser("some-user"));
    }

    @Test
    public void existsRole() {
        SecurityContextUserResolver securityContextUserResolver = new SecurityContextUserResolver();
        Assert.assertThrows(IllegalStateException.class, () -> securityContextUserResolver.existsRole("some-role"));
    }

    @Test
    public void getRolesEmpty() {
        SecurityContextUserResolver securityContextUserResolver = new SecurityContextUserResolver();
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Collections.emptyList());
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        securityContextUserResolver.getRoles("some-user");
        ((Authentication)Mockito.verify((Object)authentication, (VerificationMode)Mockito.atLeastOnce())).getAuthorities();
    }

    @Test
    public void getRoles() {
        SecurityContextUserResolver securityContextUserResolver = new SecurityContextUserResolver();
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Collections.singletonList(GeoServerRole.AUTHENTICATED_ROLE));
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        securityContextUserResolver.getRoles("some-user");
        ((Authentication)Mockito.verify((Object)authentication, (VerificationMode)Mockito.atLeastOnce())).getAuthorities();
    }
}

