/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.server.internal.InternalUserResolver;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.MemoryRoleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalUserResolverTest
extends AbstractSecurityServiceTest {
    protected GeoServerRoleService service;
    protected GeoServerRoleStore store;

    protected void onSetUp(SystemTestData testData) throws Exception {
        this.addUser("pippo", "clown", null, Arrays.asList("CIRCUS", "KLINIEK", "ZEVER"));
        this.addUser("jantje", "jantje", null, Arrays.asList("MOPJES", "ZEVER"));
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        GeoServerUserGroupService userGroupService = secMgr.loadUserGroupService("default");
        GeoServerRoleService roleService = secMgr.loadRoleService("default");
        GeoServerUserGroupStore userGroupStore = userGroupService.createStore();
        GeoServerRoleStore rolesStore = roleService.createStore();
        GeoServerUser roleUserTest = userGroupService.createUserObject("role_user_test", "role_user_test", true);
        userGroupStore.addUser(roleUserTest);
        GeoServerRole roleTest = rolesStore.createRoleObject("ROLE_TEST");
        rolesStore.addRole(roleTest);
        rolesStore.associateRoleToUser(roleTest, "role_user_test");
        GeoServerRole roleTest2 = rolesStore.createRoleObject("ROLE_TEST_2");
        rolesStore.addRole(roleTest2);
        GeoServerUserGroup roleGroup = userGroupService.createGroupObject("ROLE_GROUP", true);
        userGroupStore.addGroup(roleGroup);
        userGroupStore.associateUserToGroup(roleUserTest, roleGroup);
        rolesStore.associateRoleToGroup(roleTest2, "ROLE_GROUP");
        userGroupStore.store();
        rolesStore.store();
    }

    public GeoServerRoleService createRoleService(String name) throws Exception {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName(name);
        config.setAdminRoleName("adminRole");
        config.setGroupAdminRoleName("groupAdminRole");
        config.setClassName(MemoryRoleService.class.getName());
        this.service = new MemoryRoleService();
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.service.setSecurityManager(this.getSecurityManager());
        this.store = this.service.createStore();
        this.addTestUser("user1", Arrays.asList("adminRole", "groupAdminRole"), this.service, this.store);
        this.addTestUser("user2", Arrays.asList("adminRole"), this.service, this.store);
        this.addTestUser("user3", Arrays.asList("role1"), this.service, this.store);
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)config);
        return this.service;
    }

    @Before
    public void setDefaultUserService() throws Exception {
        this.service = this.createRoleService("test");
        this.service = this.getSecurityManager().loadRoleService("test");
        System.setProperty("org.geoserver.rest.DefaultUserGroupServiceName", "test");
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        this.service = null;
        InternalUserResolverTest.testData = new SystemTestData();
        try {
            if (System.getProperty("IS_GEOFENCE_AVAILABLE") != null) {
                System.clearProperty("IS_GEOFENCE_AVAILABLE");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not remove System ENV variable {IS_GEOFENCE_AVAILABLE}", e);
        }
    }

    protected void addTestUser(String username, List<String> roles, GeoServerRoleService service, GeoServerRoleStore store) throws Exception {
        if (roles != null && !roles.isEmpty()) {
            for (String roleName : roles) {
                GeoServerRole role = store.getRoleByName(roleName);
                if (role == null) {
                    role = service.createRoleObject(roleName);
                    store.addRole(role);
                }
                store.associateRoleToUser(role, username);
            }
        }
        store.store();
    }

    @Test
    public void testInternalUserResolver() throws Exception {
        InternalUserResolver resolver = new InternalUserResolver(this.getSecurityManager());
        Assert.assertEquals((Object)"default", (Object)this.getSecurityManager().getActiveRoleService().getName());
        Assert.assertTrue((boolean)resolver.existsUser("pippo"));
        Assert.assertTrue((boolean)resolver.existsUser("jantje"));
        Assert.assertTrue((boolean)resolver.existsUser("role_user_test"));
        Assert.assertTrue((boolean)resolver.existsRole("ZEVER"));
        Assert.assertTrue((boolean)resolver.existsRole("CIRCUS"));
        Assert.assertTrue((boolean)resolver.existsRole("MOPJES"));
        Assert.assertTrue((boolean)resolver.existsRole("KLINIEK"));
        Assert.assertTrue((boolean)resolver.existsRole("ROLE_TEST"));
        Set roles = resolver.getRoles("pippo");
        Assert.assertEquals((long)3L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("CIRCUS"));
        Assert.assertTrue((boolean)roles.contains("ZEVER"));
        Assert.assertTrue((boolean)roles.contains("KLINIEK"));
        roles = resolver.getRoles("jantje");
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("ZEVER"));
        Assert.assertTrue((boolean)roles.contains("MOPJES"));
        roles = resolver.getRoles("role_user_test");
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("ROLE_TEST"));
        Assert.assertTrue((boolean)roles.contains("ROLE_TEST_2"));
        Assert.assertEquals((Object)"test", (Object)resolver.getDefaultSecurityService().getName());
        Assert.assertTrue((boolean)(resolver.getDefaultSecurityService() instanceof GeoServerRoleService));
        GeoServerRoleStore store = ((GeoServerRoleService)resolver.getDefaultSecurityService()).createStore();
        this.addTestUser("user1", Arrays.asList("adminRole", "groupAdminRole"), this.service, store);
        this.addTestUser("user2", Arrays.asList("adminRole"), this.service, store);
        this.addTestUser("user3", Arrays.asList("role1"), this.service, store);
        Assert.assertEquals((long)3L, (long)this.service.getRoleCount());
        Assert.assertEquals((long)3L, (long)((GeoServerRoleService)resolver.getDefaultSecurityService()).getRoleCount());
        Assert.assertTrue((boolean)resolver.existsUser("user1"));
        Assert.assertTrue((boolean)resolver.existsUser("user2"));
        Assert.assertTrue((boolean)resolver.existsUser("user3"));
        Assert.assertTrue((boolean)resolver.existsRole("adminRole"));
        Assert.assertTrue((boolean)resolver.existsRole("groupAdminRole"));
        Assert.assertTrue((boolean)resolver.existsRole("role1"));
        roles = resolver.getRoles("user1");
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("adminRole"));
        Assert.assertTrue((boolean)roles.contains("groupAdminRole"));
        roles = resolver.getRoles("user2");
        Assert.assertEquals((long)1L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("adminRole"));
        roles = resolver.getRoles("user3");
        Assert.assertEquals((long)1L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("role1"));
    }
}

