/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.internal;

import org.geoserver.geofence.ServicesTest;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.server.rest.RulesRestController;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.RuleReaderServiceImpl;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class InternalServicesTest
extends ServicesTest {
    protected RulesRestController controller;
    protected RuleAdminService adminService;

    @Before
    public void initGeoFenceControllers() {
        this.controller = (RulesRestController)applicationContext.getBean("rulesRestController");
        this.adminService = (RuleAdminService)applicationContext.getBean("ruleAdminService");
        if (this.adminService.getCountAll() > 0L) {
            for (ShortRule r : this.adminService.getAll()) {
                this.adminService.delete(r.getId().longValue());
            }
        }
        Rule citeRule = new Rule(0L, "cite", null, null, null, "wms", null, null, "cite", null, GrantType.ALLOW);
        Rule sfRule = new Rule(1L, "cite", null, null, null, "wms", null, null, "sf", null, GrantType.ALLOW);
        this.adminService.insert(citeRule);
        this.adminService.insert(sfRule);
    }

    @Test
    public void testConfigurationInternal() {
        Assert.assertTrue((boolean)configManager.getConfiguration().isInternal());
        if (geofenceService != null) {
            Assert.assertTrue((boolean)(geofenceService instanceof RuleReaderServiceImpl));
        }
    }

    @Test
    public void testAllowedAreaSRIDIsPreserved() throws ParseException {
        Rule rule1 = new Rule(999L, null, null, null, null, null, null, null, null, null, GrantType.ALLOW);
        this.adminService.insert(rule1);
        Rule rule2 = new Rule(0L, null, null, null, null, null, null, null, null, "layerGroup", GrantType.LIMIT);
        Long idRule2 = this.adminService.insert(rule2);
        RuleLimits ruleLimits = new RuleLimits();
        ruleLimits.setCatalogMode(CatalogMode.HIDE);
        MultiPolygon mp = (MultiPolygon)new WKTReader().read("MULTIPOLYGON(((0.0016139656066815888 -0.0006386457758059581,0.0019599705696027314 -0.0006386457758059581,0.0019599705696027314 -0.0008854090051601674,0.0016139656066815888 -0.0008854090051601674,0.0016139656066815888 -0.0006386457758059581)))");
        mp.setSRID(3857);
        ruleLimits.setAllowedArea(mp);
        this.adminService.setLimits(idRule2, ruleLimits);
        RuleFilter filter = new RuleFilter();
        filter.setLayer("layerGroup");
        AccessInfo accessInfo = geofenceService.getAccessInfo(filter);
        String srid = accessInfo.getAreaWkt().split(";")[0].split("=")[1];
        Assert.assertEquals((Object)"3857", (Object)srid);
    }
}

