/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.geofence.server.web.GeofenceRulePage;
import org.geoserver.geofence.server.web.GeofenceRulesModel;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDNDBehavior;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import wicketdnd.DragSource;
import wicketdnd.DropTarget;
import wicketdnd.Location;
import wicketdnd.Operation;
import wicketdnd.Transfer;
import wicketdnd.theme.WebTheme;

public class GeofenceServerPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -8258166751239553791L;
    private GeofenceRulesModel rulesModel;
    private GeoServerTablePanel<ShortRule> rulesPanel;
    private AjaxLink<Object> remove;

    public GeofenceServerPage() {
        this.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = 8443763075141885559L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new GeofenceRulePage(GeofenceServerPage.this.rulesModel.newRule(), GeofenceServerPage.this.rulesModel));
            }
        }});
        Component[] componentArray = new Component[1];
        this.remove = new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 3581476968062788921L;

            public void onClick(AjaxRequestTarget target) {
                GeofenceServerPage.this.rulesModel.remove(GeofenceServerPage.this.rulesPanel.getSelection());
                target.add(new Component[]{GeofenceServerPage.this.rulesPanel});
            }
        };
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        Component[] componentArray2 = new Component[1];
        this.rulesModel = new GeofenceRulesModel();
        this.rulesPanel = new GeoServerTablePanel<ShortRule>("rulesPanel", (GeoServerDataProvider)this.rulesModel, true){
            private static final long serialVersionUID = -8943273843044917552L;

            protected Component getComponentForProperty(String id, IModel<ShortRule> itemModel, GeoServerDataProvider.Property<ShortRule> property) {
                if (property == GeofenceRulesModel.BUTTONS) {
                    return new ButtonPanel(id, (ShortRule)itemModel.getObject());
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                GeofenceServerPage.this.remove.setEnabled(!GeofenceServerPage.this.rulesPanel.getSelection().isEmpty());
                target.add(new Component[]{GeofenceServerPage.this.remove});
            }
        };
        componentArray2[0] = this.rulesPanel;
        this.add(componentArray2);
        this.rulesPanel.add(new Behavior[]{new WebTheme()});
        this.rulesPanel.add(new Behavior[]{new DragSource(new Operation[]{Operation.MOVE}).drag("tr")});
        this.rulesPanel.add(new Behavior[]{new DropTarget(new Operation[]{Operation.MOVE}){
            private static final long serialVersionUID = 543875667418965337L;

            public void onDrop(AjaxRequestTarget target, Transfer transfer, Location location) {
                if (location == null || !(location.getComponent().getDefaultModel().getObject() instanceof ShortRule)) {
                    return;
                }
                ShortRule movedRule = (ShortRule)transfer.getData();
                ShortRule targetRule = (ShortRule)location.getComponent().getDefaultModel().getObject();
                if (movedRule.getId().equals(targetRule.getId())) {
                    return;
                }
                if (movedRule.getPriority() < targetRule.getPriority()) {
                    movedRule.setPriority(targetRule.getPriority() + 1L);
                } else {
                    movedRule.setPriority(targetRule.getPriority());
                }
                GeofenceServerPage.this.rulesModel.save(movedRule);
                GeofenceServerPage.this.doReturn(GeofenceServerPage.class);
            }
        }.dropCenter("tr")});
        this.rulesPanel.add(new Behavior[]{new GeoServerDNDBehavior()});
        this.rulesPanel.setOutputMarkupId(true);
    }

    private class ButtonPanel
    extends Panel {
        private static final long serialVersionUID = 833648465957566970L;
        private ImageAjaxLink<?> upLink;
        private ImageAjaxLink<?> downLink;

        public ButtonPanel(String id, final ShortRule rule) {
            super(id);
            this.setOutputMarkupId(true);
            this.upLink = new ImageAjaxLink<Object>("up", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/arrow_up.png")){
                private static final long serialVersionUID = -8179503447106596760L;

                protected void onClick(AjaxRequestTarget target) {
                    GeofenceServerPage.this.rulesModel.moveUp(rule);
                    target.add(new Component[]{GeofenceServerPage.this.rulesPanel});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (GeofenceServerPage.this.rulesModel.canUp(rule)) {
                        tag.put("class", (CharSequence)"visibility-visible");
                    } else {
                        tag.put("class", (CharSequence)"visibility-hidden");
                    }
                }
            };
            this.upLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerPage.up", this.upLink, new Object[0]))});
            this.upLink.setOutputMarkupId(true);
            this.add(new Component[]{this.upLink});
            this.downLink = new ImageAjaxLink<Object>("down", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/arrow_down.png")){
                private static final long serialVersionUID = 4640187752303674221L;

                protected void onClick(AjaxRequestTarget target) {
                    GeofenceServerPage.this.rulesModel.moveDown(rule);
                    target.add(new Component[]{GeofenceServerPage.this.rulesPanel});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (GeofenceServerPage.this.rulesModel.canDown(rule)) {
                        tag.put("class", (CharSequence)"visibility-visible");
                    } else {
                        tag.put("class", (CharSequence)"visibility-hidden");
                    }
                }
            };
            this.downLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerPage.down", this.downLink, new Object[0]))});
            this.downLink.setOutputMarkupId(true);
            this.add(new Component[]{this.downLink});
            ImageAjaxLink<Object> editLink = new ImageAjaxLink<Object>("edit", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/edit.png")){
                private static final long serialVersionUID = 4640187752303674221L;

                protected void onClick(AjaxRequestTarget target) {
                    this.setResponsePage((IRequestablePage)new GeofenceRulePage(rule, GeofenceServerPage.this.rulesModel));
                }
            };
            editLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerPage.edit", (Component)editLink, new Object[0]))});
            editLink.setOutputMarkupId(true);
            this.add(new Component[]{editLink});
        }
    }
}

