/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.server.web.GeofenceAdminRulesModel;
import org.geoserver.geofence.server.web.GeofenceServerAdminPage;
import org.geoserver.geofence.server.web.GeofenceServerPage;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.springframework.dao.DuplicateKeyException;

public class GeofenceAdminRulePage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -1652083500548496180L;
    protected DropDownChoice<String> userChoice;
    protected DropDownChoice<String> roleChoice;
    protected DropDownChoice<String> workspaceChoice;
    protected DropDownChoice<AdminGrantType> grantTypeChoice;

    public GeofenceAdminRulePage(ShortAdminRule rule, final GeofenceAdminRulesModel rules) {
        final Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)rule));
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("priority").setRequired(true)});
        Component[] componentArray = new Component[1];
        this.roleChoice = new DropDownChoice("roleName", this.getRoleNames());
        componentArray[0] = this.roleChoice;
        form.add(componentArray);
        this.roleChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = -8846522500239968004L;

            protected void onUpdate(AjaxRequestTarget target) {
                GeofenceAdminRulePage.this.userChoice.setChoices(GeofenceAdminRulePage.this.getUserNames((String)GeofenceAdminRulePage.this.roleChoice.getConvertedInput()));
                ((ShortAdminRule)form.getModelObject()).setUserName(null);
                GeofenceAdminRulePage.this.userChoice.modelChanged();
                target.add(new Component[]{GeofenceAdminRulePage.this.userChoice});
            }
        }});
        this.roleChoice.setNullValid(true);
        Component[] componentArray2 = new Component[1];
        this.userChoice = new DropDownChoice("userName", this.getUserNames(rule.getRoleName()));
        componentArray2[0] = this.userChoice;
        form.add(componentArray2);
        this.userChoice.setOutputMarkupId(true);
        this.userChoice.setNullValid(true);
        Component[] componentArray3 = new Component[1];
        this.workspaceChoice = new DropDownChoice("workspace", this.getWorkspaceNames());
        componentArray3[0] = this.workspaceChoice;
        form.add(componentArray3);
        this.workspaceChoice.setNullValid(true);
        Component[] componentArray4 = new Component[1];
        this.grantTypeChoice = new DropDownChoice("access", Arrays.asList(AdminGrantType.values()), (IChoiceRenderer)new AdminGrantTypeRenderer());
        componentArray4[0] = this.grantTypeChoice;
        form.add(componentArray4);
        this.grantTypeChoice.setRequired(true);
        form.add(new Component[]{new SubmitLink("save"){
            private static final long serialVersionUID = -6524151967046867889L;

            public void onSubmit() {
                ShortAdminRule rule = (ShortAdminRule)this.getForm().getModelObject();
                try {
                    rules.save(rule);
                    GeofenceAdminRulePage.this.doReturn(GeofenceServerAdminPage.class);
                }
                catch (DuplicateKeyException e) {
                    this.error((Serializable)((Object)new ResourceModel("GeofenceRulePage.duplicate").getObject()));
                }
                catch (Exception exception) {
                    this.error(exception);
                }
            }
        }});
        form.add(new Component[]{new BookmarkablePageLink("cancel", GeofenceServerPage.class)});
    }

    protected List<String> getWorkspaceNames() {
        TreeSet<String> resultSet = new TreeSet<String>();
        for (WorkspaceInfo ws : this.getCatalog().getFacade().getWorkspaces()) {
            resultSet.add(ws.getName());
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getRoleNames() {
        TreeSet<String> resultSet = new TreeSet<String>();
        try {
            for (GeoServerRole role : this.securityManager().getRolesForAccessControl()) {
                resultSet.add(role.getAuthority());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getUserNames(String roleName) {
        TreeSet<String> resultSet = new TreeSet<String>();
        GeoServerSecurityManager securityManager = this.securityManager();
        try {
            if (roleName == null) {
                for (String serviceName : securityManager.listUserGroupServices()) {
                    for (GeoServerUser user : securityManager.loadUserGroupService(serviceName).getUsers()) {
                        resultSet.add(user.getUsername());
                    }
                }
            } else {
                for (String serviceName : securityManager.listRoleServices()) {
                    GeoServerRoleService roleService = securityManager.loadRoleService(serviceName);
                    GeoServerRole role = roleService.getRoleByName(roleName);
                    if (role == null) continue;
                    resultSet.addAll(roleService.getUserNamesForRole(role));
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return new ArrayList<String>(resultSet);
    }

    protected GeoServerSecurityManager securityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    protected class AdminGrantTypeRenderer
    extends ChoiceRenderer<AdminGrantType> {
        private static final long serialVersionUID = -7146780173551842734L;

        protected AdminGrantTypeRenderer() {
        }

        public Object getDisplayValue(AdminGrantType object) {
            return new ParamResourceModel(object.name(), (Component)GeofenceAdminRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(AdminGrantType object, int index) {
            return object.name();
        }
    }
}

