/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRuleList;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.geoserver.rest.RestBaseController;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/geofence"})
public class AdminRulesRestController
extends RestBaseController {
    private AdminRuleAdminService adminService;

    public AdminRulesRestController(AdminRuleAdminService adminService) {
        this.adminService = adminService;
    }

    @ExceptionHandler(value={NotFoundServiceEx.class})
    public void ruleNotFound(NotFoundServiceEx exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, exception.getMessage());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public void rule(DuplicateKeyException exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(409, exception.getMessage());
    }

    @RequestMapping(value={"/adminrules"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public JaxbAdminRuleList get(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="entries", required=false) Integer entries, @RequestParam(value="full", required=false, defaultValue="false") boolean full, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="userAny", required=false) Boolean userDefault, @RequestParam(value="roleName", required=false) String roleName, @RequestParam(value="roleAny", required=false) Boolean roleDefault, @RequestParam(value="workspace", required=false) String workspace, @RequestParam(value="workspaceAny", required=false) Boolean workspaceDefault) {
        RuleFilter filter = this.buildFilter(userName, userDefault, roleName, roleDefault, workspace, workspaceDefault);
        return new JaxbAdminRuleList(this.adminService.getListFull(filter, page, entries));
    }

    @RequestMapping(value={"/adminrules/id/{id}"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public JaxbAdminRule get(@PathVariable(value="id") Long id) {
        return new JaxbAdminRule(this.adminService.get(id.longValue()));
    }

    @RequestMapping(value={"/adminrules/count"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public JaxbAdminRuleList count(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="userAny", required=false) Boolean userDefault, @RequestParam(value="roleName", required=false) String roleName, @RequestParam(value="roleAny", required=false) Boolean roleDefault, @RequestParam(value="workspace", required=false) String workspace, @RequestParam(value="workspaceAny", required=false) Boolean workspaceDefault) {
        RuleFilter filter = this.buildFilter(userName, userDefault, roleName, roleDefault, workspace, workspaceDefault);
        return new JaxbAdminRuleList(this.adminService.count(filter));
    }

    @RequestMapping(value={"/adminrules"}, method={RequestMethod.POST})
    public ResponseEntity<Long> insert(@RequestBody JaxbAdminRule rule) {
        long priority;
        long l = priority = rule.getPriority() == null ? 0L : rule.getPriority();
        if (this.adminService.getRuleByPriority(priority) != null) {
            this.adminService.shift(priority, 1L);
        }
        return new ResponseEntity((Object)this.adminService.insert(rule.toRule()), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/adminrules/id/{id}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.OK)
    public void update(@PathVariable(value="id") Long id, @RequestBody JaxbAdminRule rule) {
        ShortAdminRule priorityRule;
        if (rule.getPriority() != null && (priorityRule = this.adminService.getRuleByPriority(rule.getPriority().longValue())) != null && priorityRule.getId().longValue() != id.longValue()) {
            this.adminService.shift(rule.getPriority().longValue(), 1L);
        }
        this.adminService.update(rule.toRule(this.adminService.get(id.longValue())));
    }

    @RequestMapping(value={"/adminrules/id/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="id") Long id) {
        this.adminService.delete(id.longValue());
    }

    protected RuleFilter buildFilter(String userName, Boolean userDefault, String roleName, Boolean groupDefault, String workspace, Boolean workspaceDefault) {
        RuleFilter filter = new RuleFilter(RuleFilter.SpecialFilterType.ANY, true);
        this.setFilter(filter.getUser(), userName, userDefault);
        this.setFilter(filter.getRole(), roleName, groupDefault);
        this.setFilter(filter.getWorkspace(), workspace, workspaceDefault);
        return filter;
    }

    private void setFilter(RuleFilter.TextFilter filter, String name, Boolean includeDefault) {
        if (name != null) {
            filter.setText(name);
            if (includeDefault != null) {
                filter.setIncludeDefault(includeDefault.booleanValue());
            }
        } else if (includeDefault != null && includeDefault.booleanValue()) {
            filter.setType(RuleFilter.SpecialFilterType.DEFAULT);
        } else {
            filter.setType(RuleFilter.SpecialFilterType.ANY);
        }
    }

    @RequestMapping(value={"/adminrules/move"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseBody
    public ResponseEntity<JaxbAdminRuleList> move(@RequestParam(value="targetPriority", required=true) int targetPriority, @RequestParam(value="rulesIds", required=true) String rulesIds) {
        List<AdminRule> rules = this.findRules(rulesIds);
        if (rules.isEmpty()) {
            return ResponseEntity.ok().build();
        }
        this.adminService.shift((long)targetPriority, (long)rules.size());
        long priority = targetPriority;
        for (AdminRule rule : rules) {
            rule.setPriority(priority);
            this.adminService.update(rule);
            ++priority;
        }
        return ResponseEntity.ok((Object)new JaxbAdminRuleList(rules));
    }

    private List<AdminRule> findRules(String rulesIds) {
        return Arrays.stream(rulesIds.split(",")).map(ruleId -> {
            try {
                return Long.parseLong(ruleId);
            }
            catch (NumberFormatException exception) {
                throw new InvalidRulesIds();
            }
        }).map(ruleId -> this.adminService.get(ruleId.longValue())).filter(rule -> rule != null).sorted((ruleA, ruleB) -> Long.compare(ruleA.getPriority(), ruleB.getPriority())).collect(Collectors.toList());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="Invalid adminrules ids")
    private class InvalidRulesIds
    extends RuntimeException {
        private InvalidRulesIds() {
        }
    }
}

