/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest.xml;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.geofence.server.rest.xml.MultiPolygonAdapter;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.v3_2.GML;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.XSD;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiPolygonAdapterTest {
    static final Logger LOGGER = Logging.getLogger(MultiPolygonAdapterTest.class);
    private MultiPolygonAdapter adapter = new MultiPolygonAdapter();

    @Test
    public void testMarshal() throws Exception {
        MultiPolygon geometry = GML3MockData.multiPolygon();
        Element element = this.adapter.marshal(geometry);
        Assert.assertEquals((long)2L, (long)element.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "geometryMember").getLength());
        NodeList children = element.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", GML.Polygon.getLocalPart());
        Assert.assertEquals((long)2L, (long)children.getLength());
    }

    @Test
    public void testUnmarshal() throws Exception {
        GML3MockData.setGML((XSD)GML.getInstance());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element allowedArea = GML3MockData.element((QName)new QName(null, "allowedArea"), (Document)document, (Node)document);
        Element multiGeometry = GML3MockData.element((QName)GML3MockData.qName((String)"MultiGeometry"), (Document)document, (Node)allowedArea);
        Element geometryMember = GML3MockData.element((QName)GML3MockData.qName((String)"geometryMember"), (Document)document, (Node)multiGeometry);
        GML3MockData.polygon((Document)document, (Node)geometryMember);
        geometryMember = GML3MockData.element((QName)GML3MockData.qName((String)"geometryMember"), (Document)document, (Node)multiGeometry);
        GML3MockData.polygon((Document)document, (Node)geometryMember);
        try {
            MultiPolygon multiPolygon = this.adapter.unmarshal((Object)allowedArea);
            Assert.assertNotNull((Object)multiPolygon);
            Assert.assertEquals((long)2L, (long)multiPolygon.getNumGeometries());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
        }
    }
}

