/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest;

import java.util.ArrayList;
import java.util.List;
import net.sf.ezmorph.test.ArrayAssertions;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.server.rest.BatchRestController;
import org.geoserver.geofence.server.rest.xml.AbstractPayload;
import org.geoserver.geofence.server.rest.xml.Batch;
import org.geoserver.geofence.server.rest.xml.BatchOperation;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbRule;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;

public class BatchRestControllerTest
extends GeofenceBaseTest {
    private BatchRestController controller;
    private RuleAdminService ruleService;
    private AdminRuleAdminService ruleAdminService;

    @Before
    public void initGeoFenceControllers() {
        this.controller = (BatchRestController)applicationContext.getBean("batchRestController");
        this.ruleService = (RuleAdminService)applicationContext.getBean("ruleAdminService");
        this.ruleAdminService = (AdminRuleAdminService)applicationContext.getBean("adminRuleAdminService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleBatch() {
        ArrayList<Long> idsToDel = new ArrayList<Long>();
        try {
            JaxbRule rule = new JaxbRule();
            rule.setPriority(Long.valueOf(2L));
            rule.setRoleName("ROLE_USER");
            rule.setWorkspace("ws");
            rule.setLayer("layer");
            rule.setAccess("ALLOW");
            long id = this.ruleService.insert(rule.toRule());
            JaxbRule rule2 = new JaxbRule();
            rule2.setPriority(Long.valueOf(2L));
            rule2.setRoleName("ROLE_USER");
            rule2.setWorkspace("ws");
            rule2.setLayer("layer");
            rule2.setAccess("LIMIT");
            JaxbRule.Limits limits = new JaxbRule.Limits();
            limits.setCatalogMode("MIXED");
            rule2.setLimits(limits);
            long id2 = this.ruleService.insert(rule2.toRule());
            this.ruleService.setLimits(Long.valueOf(id2), rule2.getLimits().toRuleLimits(null));
            JaxbRule rule3 = new JaxbRule();
            rule3.setPriority(Long.valueOf(99L));
            rule3.setRoleName("ROLE_ANONYMOUS");
            rule3.setWorkspace("ws");
            rule3.setLayer("layer");
            rule3.setAccess("DENY");
            Batch batch = new Batch();
            BatchOperation op = new BatchOperation();
            op.setPayload((AbstractPayload)rule3);
            op.setService(BatchOperation.ServiceName.rules);
            op.setType(BatchOperation.TypeName.insert);
            batch.add(op);
            BatchOperation op2 = new BatchOperation();
            op2.setService(BatchOperation.ServiceName.rules);
            op2.setType(BatchOperation.TypeName.delete);
            op2.setId(Long.valueOf(id2));
            batch.add(op2);
            BatchOperation op3 = new BatchOperation();
            op3.setService(BatchOperation.ServiceName.rules);
            op3.setType(BatchOperation.TypeName.update);
            op3.setId(Long.valueOf(id));
            rule.setAccess("DENY");
            op3.setPayload((AbstractPayload)rule);
            batch.add(op3);
            HttpStatus status = this.controller.exec(batch);
            ArrayAssertions.assertEquals((int)200, (int)status.value());
            Rule deleted = null;
            try {
                deleted = this.ruleService.get(id2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertNull(deleted);
            Rule updated = this.ruleService.get(id);
            ArrayAssertions.assertEquals((Object)GrantType.DENY, (Object)updated.getAccess());
            ArrayAssertions.assertEquals((String)"ROLE_USER", (String)updated.getRolename());
            ShortRule inserted = this.ruleService.getRuleByPriority(99L);
            ArrayAssertions.assertEquals((Object)GrantType.DENY, (Object)inserted.getAccess());
            ArrayAssertions.assertEquals((String)"ROLE_ANONYMOUS", (String)inserted.getRoleName());
            idsToDel.add(id);
            idsToDel.add(inserted.getId());
        }
        finally {
            this.deleteRules(idsToDel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminRuleBatch() {
        ArrayList<Long> idsToDel = new ArrayList<Long>();
        try {
            JaxbAdminRule adminRule = new JaxbAdminRule();
            adminRule.setRoleName("ROLE_USER");
            adminRule.setWorkspace("ws00");
            adminRule.setAccess(AdminGrantType.USER.name());
            Long id = this.ruleAdminService.insert(adminRule.toRule());
            AdminRule adminRule2 = new AdminRule();
            adminRule2.setRolename("ROLE_USER2");
            adminRule2.setWorkspace("ws22");
            adminRule2.setAccess(AdminGrantType.ADMIN);
            Long id2 = this.ruleAdminService.insert(adminRule2);
            JaxbAdminRule adminRule3 = new JaxbAdminRule();
            adminRule3.setRoleName("ROLE_USER3");
            adminRule3.setWorkspace("ws33");
            adminRule3.setPriority(Long.valueOf(999L));
            adminRule3.setAccess(AdminGrantType.ADMIN.name());
            Batch batch = new Batch();
            BatchOperation operation = new BatchOperation();
            operation.setService(BatchOperation.ServiceName.adminrules);
            operation.setType(BatchOperation.TypeName.insert);
            operation.setPayload((AbstractPayload)adminRule3);
            batch.add(operation);
            BatchOperation operation2 = new BatchOperation();
            operation2.setService(BatchOperation.ServiceName.adminrules);
            operation2.setType(BatchOperation.TypeName.delete);
            operation2.setId(id2);
            batch.add(operation2);
            BatchOperation operation3 = new BatchOperation();
            operation3.setService(BatchOperation.ServiceName.adminrules);
            operation3.setType(BatchOperation.TypeName.update);
            operation3.setId(id);
            adminRule.setWorkspace("ws012");
            operation3.setPayload((AbstractPayload)adminRule);
            batch.add(operation3);
            this.controller.exec(batch);
            AdminRule rule = this.ruleAdminService.get(id.longValue());
            ArrayAssertions.assertEquals((String)"ws012", (String)rule.getWorkspace());
            ArrayAssertions.assertEquals((Object)AdminGrantType.USER, (Object)rule.getAccess());
            ArrayAssertions.assertEquals((String)"ROLE_USER", (String)rule.getRolename());
            AdminRule deleted = null;
            try {
                deleted = this.ruleAdminService.get(id2.longValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertNull(deleted);
            ShortAdminRule inserted = this.ruleAdminService.getRuleByPriority(999L);
            ArrayAssertions.assertEquals((String)"ws33", (String)inserted.getWorkspace());
            ArrayAssertions.assertEquals((String)"ROLE_USER3", (String)inserted.getRoleName());
            ArrayAssertions.assertEquals((Object)AdminGrantType.ADMIN, (Object)inserted.getAccess());
            idsToDel.add(id);
            idsToDel.add(inserted.getId());
        }
        finally {
            this.deleteAdminRules(idsToDel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixedServiceBatch() {
        Long adminId = null;
        Long ruleId = null;
        try {
            JaxbRule rule = new JaxbRule();
            rule.setPriority(Long.valueOf(2L));
            rule.setRoleName("ROLE_USER4");
            rule.setWorkspace("ws");
            rule.setLayer("layer");
            rule.setAccess("ALLOW");
            long id = this.ruleService.insert(rule.toRule());
            Batch batch = new Batch();
            BatchOperation op = new BatchOperation();
            op.setService(BatchOperation.ServiceName.rules);
            op.setType(BatchOperation.TypeName.update);
            op.setId(Long.valueOf(id));
            rule.setAccess("DENY");
            rule.setRoleName("ROLE_USER5");
            op.setPayload((AbstractPayload)rule);
            batch.add(op);
            JaxbAdminRule adminRule = new JaxbAdminRule();
            adminRule.setPriority(Long.valueOf(9999L));
            adminRule.setRoleName("ROLE_USER6");
            adminRule.setAccess("ADMIN");
            adminRule.setWorkspace("ws99");
            BatchOperation op2 = new BatchOperation();
            op2.setService(BatchOperation.ServiceName.adminrules);
            op2.setType(BatchOperation.TypeName.insert);
            op2.setPayload((AbstractPayload)adminRule);
            batch.add(op2);
            HttpStatus status = this.controller.exec(batch);
            ArrayAssertions.assertEquals((int)200, (int)status.value());
            Rule updated = this.ruleService.get(id);
            ArrayAssertions.assertEquals((Object)GrantType.DENY, (Object)updated.getAccess());
            ArrayAssertions.assertEquals((String)"ROLE_USER5", (String)updated.getRolename());
            ShortAdminRule inserted = this.ruleAdminService.getRuleByPriority(9999L);
            ArrayAssertions.assertEquals((Object)AdminGrantType.ADMIN, (Object)inserted.getAccess());
            ArrayAssertions.assertEquals((String)"ws99", (String)inserted.getWorkspace());
            ArrayAssertions.assertEquals((String)"ROLE_USER6", (String)inserted.getRoleName());
            ruleId = id;
            adminId = inserted.getId();
        }
        finally {
            if (adminId != null) {
                this.ruleAdminService.delete(adminId.longValue());
            }
            if (ruleId != null) {
                this.ruleService.delete(ruleId.longValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalRollback() {
        Long ruleId = null;
        try {
            JaxbRule rule = new JaxbRule();
            rule.setPriority(Long.valueOf(2L));
            rule.setRoleName("ROLE_USER4");
            rule.setWorkspace("ws44");
            rule.setLayer("layer");
            rule.setAccess("ALLOW");
            long id = this.ruleService.insert(rule.toRule());
            ruleId = id;
            Batch batch = new Batch();
            BatchOperation op = new BatchOperation();
            op.setService(BatchOperation.ServiceName.rules);
            op.setType(BatchOperation.TypeName.update);
            op.setId(Long.valueOf(id));
            rule.setAccess("DENY");
            rule.setRoleName("ROLE_USER5");
            op.setPayload((AbstractPayload)rule);
            batch.add(op);
            JaxbRule dup = new JaxbRule();
            dup.setPriority(Long.valueOf(1L));
            dup.setRoleName("ROLE_USER9");
            dup.setWorkspace("ws99");
            dup.setLayer("layer99");
            dup.setAccess("ALLOW");
            this.ruleService.insert(dup.toRule());
            BatchOperation op2 = new BatchOperation();
            op2.setService(BatchOperation.ServiceName.rules);
            op2.setType(BatchOperation.TypeName.insert);
            dup.setPriority(Long.valueOf(99999L));
            op2.setPayload((AbstractPayload)dup);
            batch.add(op2);
            String message = null;
            try {
                this.controller.exec(batch);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof BadRequestServiceEx));
                message = e.getMessage();
            }
            ArrayAssertions.assertEquals((String)"The operation is trying to add a duplicate rule or adminrule", (String)message);
            Rule updated = this.ruleService.get(id);
            ArrayAssertions.assertEquals((Object)GrantType.ALLOW, (Object)updated.getAccess());
            ArrayAssertions.assertEquals((String)"ROLE_USER4", (String)updated.getRolename());
            ShortRule inserted = null;
            try {
                inserted = this.ruleService.getRuleByPriority(99999L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertNull(inserted);
        }
        finally {
            if (ruleId != null) {
                this.ruleService.delete(ruleId.longValue());
            }
        }
    }

    @Test
    public void testMissingServiceName() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(1L));
        rule.setRoleName("ROLE_USER9");
        rule.setWorkspace("ws99");
        rule.setLayer("layer99");
        rule.setAccess("ALLOW");
        Batch batch = new Batch();
        BatchOperation op = new BatchOperation();
        op.setType(BatchOperation.TypeName.update);
        op.setPayload((AbstractPayload)rule);
        batch.add(op);
        String message = null;
        try {
            this.controller.exec(batch);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestServiceEx));
            message = e.getMessage();
        }
        ArrayAssertions.assertEquals((String)"The operation service is mandatory but on or more operation elements doesn't have it", (String)message);
    }

    @Test
    public void testMissingTypeName() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(1L));
        rule.setRoleName("ROLE_USER9");
        rule.setWorkspace("ws99");
        rule.setLayer("layer99");
        rule.setAccess("ALLOW");
        Batch batch = new Batch();
        BatchOperation op = new BatchOperation();
        op.setService(BatchOperation.ServiceName.rules);
        op.setPayload((AbstractPayload)rule);
        batch.add(op);
        String message = null;
        try {
            this.controller.exec(batch);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestServiceEx));
            message = e.getMessage();
        }
        ArrayAssertions.assertEquals((String)"The operation type is mandatory but on or more operation elements doesn't have it", (String)message);
    }

    @Test
    public void testMissingId() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(1L));
        rule.setRoleName("ROLE_USER9");
        rule.setWorkspace("ws99");
        rule.setLayer("layer99");
        rule.setAccess("ALLOW");
        Batch batch = new Batch();
        BatchOperation op = new BatchOperation();
        op.setService(BatchOperation.ServiceName.rules);
        op.setType(BatchOperation.TypeName.update);
        op.setPayload((AbstractPayload)rule);
        batch.add(op);
        String message = null;
        try {
            this.controller.exec(batch);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestServiceEx));
            message = e.getMessage();
        }
        ArrayAssertions.assertEquals((String)"An id is required for operation type update", (String)message);
    }

    @Test
    public void testMissingPayload() {
        Batch batch = new Batch();
        BatchOperation op = new BatchOperation();
        op.setService(BatchOperation.ServiceName.rules);
        op.setType(BatchOperation.TypeName.update);
        op.setId(Long.valueOf(10L));
        batch.add(op);
        String message = null;
        try {
            this.controller.exec(batch);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BadRequestServiceEx));
            message = e.getMessage();
        }
        ArrayAssertions.assertEquals((String)"An operation requiring a Rule payload doesn't have it", (String)message);
    }

    @Test
    public void testNotFound() {
        Batch batch = new Batch();
        BatchOperation op = new BatchOperation();
        op.setService(BatchOperation.ServiceName.rules);
        op.setType(BatchOperation.TypeName.delete);
        op.setId(Long.valueOf(1000000L));
        batch.add(op);
        String message = null;
        try {
            this.controller.exec(batch);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NotFoundServiceEx));
            message = e.getMessage();
        }
        ArrayAssertions.assertEquals((String)"Rule not found (id:1000000)", (String)message);
    }

    private void deleteRules(List<Long> ids) {
        for (Long id : ids) {
            this.ruleService.delete(id.longValue());
        }
    }

    private void deleteAdminRules(List<Long> ids) {
        for (Long id : ids) {
            this.ruleAdminService.delete(id.longValue());
        }
    }
}

