/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.server.integration.GeofenceWMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetLegendGraphicGeofenceTest
extends GeofenceWMSTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLegendGraphicNestedGroups() throws Exception {
        Long ruleId1 = null;
        LayerGroupInfo group = null;
        LayerGroupInfo nested = null;
        try {
            ruleId1 = GetLegendGraphicGeofenceTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, "nested");
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.OPAQUE_CONTAINER, "container");
            this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
            group = this.getCatalog().getLayerGroupByName("container");
            nested = this.getCatalog().getLayerGroupByName("nested");
            group.getLayers().add(nested);
            group.getStyles().add(null);
            this.getCatalog().save(group);
            this.logout();
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + group.getName() + "&style=&format=image/png&width=20&height=20";
            MockHttpServletResponse response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)response.getContentType(), (Object)"image/png");
        }
        catch (Throwable throwable) {
            GetLegendGraphicGeofenceTest.deleteRules(this.ruleService, ruleId1);
            this.logout();
            this.removeLayerGroup(group);
            this.removeLayerGroup(nested);
            throw throwable;
        }
        GetLegendGraphicGeofenceTest.deleteRules(this.ruleService, ruleId1);
        this.logout();
        this.removeLayerGroup(group);
        this.removeLayerGroup(nested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLegendGraphicLayerGroupStyle() throws Exception {
        Long ruleId1 = null;
        Long ruleId2 = null;
        LayerGroupInfo group = null;
        String layerGroupName = "lakes_and_places_legend";
        try {
            ruleId1 = GetLegendGraphicGeofenceTest.addRule(GrantType.ALLOW, null, null, null, null, null, null, 1L, this.ruleService);
            ruleId2 = GetLegendGraphicGeofenceTest.addRule(GrantType.ALLOW, null, "ROLE_ANONYMOUS", "WMS", null, "cite", "Forests", 0L, this.ruleService);
            List<String> allowedStyles = Arrays.asList("Lakes", "NamedPlaces");
            GetLegendGraphicGeofenceTest.addLayerDetails(this.ruleService, ruleId2, new HashSet<String>(allowedStyles), Collections.emptySet(), CatalogMode.HIDE, null, null, LayerType.VECTOR);
            this.addLakesPlacesLayerGroup(LayerGroupInfo.Mode.SINGLE, layerGroupName);
            this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
            group = this.getCatalog().getLayerGroupByName(layerGroupName);
            StyleInfo polygonStyle = this.getCatalog().getStyleByName("polygon");
            LayerInfo forest = this.getCatalog().getLayerByName(this.getLayerId(MockData.FORESTS));
            forest.getStyles().add(polygonStyle);
            this.getCatalog().save(forest);
            ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
            styles.add(polygonStyle);
            this.addLayerGroupStyle(group, "forests_style", Arrays.asList(forest), styles);
            this.logout();
            this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
            String url = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + group.getName() + "&style=&format=image/png&width=20&height=20";
            MockHttpServletResponse response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)response.getContentType(), (Object)"image/png");
            url = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + group.getName() + "&style=forests_style&format=image/png&width=20&height=20";
            response = this.getAsServletResponse(url);
            Assert.assertEquals((Object)this.getBaseMimeType(response.getContentType()), (Object)"application/vnd.ogc.se_xml");
            Assert.assertTrue((boolean)response.getContentAsString().contains("style is not available on this layer"));
        }
        catch (Throwable throwable) {
            GetLegendGraphicGeofenceTest.deleteRules(this.ruleService, ruleId1, ruleId2);
            this.logout();
            this.removeLayerGroup(group);
            throw throwable;
        }
        GetLegendGraphicGeofenceTest.deleteRules(this.ruleService, ruleId1, ruleId2);
        this.logout();
        this.removeLayerGroup(group);
    }
}

