/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.geoserver.geofence.cache.CacheManager;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.GSInstance;
import org.geoserver.geofence.core.model.IPAddressRange;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerTestApplicationContext;
import org.junit.rules.ExternalResource;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeofenceIntegrationTestSupport
extends ExternalResource {
    private RuleAdminService ruleService;
    private AdminRuleAdminService adminRuleService;
    private Supplier<GeoServerTestApplicationContext> appContext;
    private List<Long> ruleIds;
    private List<Long> adminRuleIds;

    public GeofenceIntegrationTestSupport(Supplier<GeoServerTestApplicationContext> appContext) {
        this.appContext = appContext;
    }

    public void before() {
        this.ruleIds = new ArrayList<Long>();
        this.adminRuleIds = new ArrayList<Long>();
        GeoServerTestApplicationContext context = this.appContext.get();
        this.ruleService = (RuleAdminService)context.getBean(RuleAdminService.class);
        this.adminRuleService = (AdminRuleAdminService)context.getBean(AdminRuleAdminService.class);
    }

    public void after() {
        this.deleteRules();
        CacheManager cacheManager = (CacheManager)GeoServerExtensions.bean(CacheManager.class);
        cacheManager.invalidateAll();
    }

    public long addAdminRule(long priority, String username, String rolename, String workspace, AdminGrantType access) {
        GSInstance gsInstance = null;
        IPAddressRange addressRange = null;
        AdminRule rule = new AdminRule(priority, username, rolename, gsInstance, addressRange, workspace, access);
        long id = this.adminRuleService.insert(rule);
        this.adminRuleIds.add(id);
        return id;
    }

    public long addRule(GrantType access, String username, String roleName, String service, String request, String workspace, String layer, long priority) {
        return this.addRule(access, username, roleName, service, request, null, workspace, layer, priority);
    }

    public long addRule(GrantType access, String username, String roleName, String service, String request, String subfield, String workspace, String layer, long priority) {
        Rule rule = new Rule();
        rule.setAccess(access);
        rule.setUsername(username);
        rule.setRolename(roleName);
        rule.setService(service);
        rule.setRequest(request);
        rule.setSubfield(subfield);
        rule.setWorkspace(workspace);
        rule.setLayer(layer);
        rule.setPriority(priority);
        long id = this.ruleService.insert(rule);
        this.ruleIds.add(id);
        return id;
    }

    public void addRuleLimits(long ruleId, CatalogMode mode, String allowedArea, Integer srid) throws ParseException {
        this.addRuleLimits(ruleId, mode, allowedArea, srid, null);
    }

    public void addRuleLimits(long ruleId, CatalogMode mode, String allowedArea, Integer srid, SpatialFilterType spatialFilterType) throws ParseException {
        RuleLimits limits = new RuleLimits();
        limits.setCatalogMode(mode);
        MultiPolygon allowedAreaGeom = (MultiPolygon)new WKTReader().read(allowedArea);
        if (srid != null) {
            allowedAreaGeom.setSRID(srid.intValue());
        }
        limits.setAllowedArea(allowedAreaGeom);
        if (spatialFilterType == null) {
            spatialFilterType = SpatialFilterType.INTERSECT;
        }
        limits.setSpatialFilterType(spatialFilterType);
        this.ruleService.setLimits(Long.valueOf(ruleId), limits);
    }

    public void deleteRules() {
        this.ruleIds.forEach(arg_0 -> ((RuleAdminService)this.ruleService).delete(arg_0));
        this.adminRuleIds.forEach(arg_0 -> ((AdminRuleAdminService)this.adminRuleService).delete(arg_0));
    }

    public void deleteRules(Long ... ids) {
        for (Long id : ids) {
            if (id == null) continue;
            this.ruleService.delete(id.longValue());
        }
    }
}

