/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gdal;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.util.Optional;
import org.gdal.gdal.gdal;
import org.geoserver.platform.ModuleStatus;
import org.geotools.factory.GeoTools;
import org.geotools.util.Version;

public class GDALStatus
implements ModuleStatus {
    public String getModule() {
        return "gs-gdal";
    }

    public Optional<String> getComponent() {
        return Optional.ofNullable("GridCoverage2DReader");
    }

    public String getName() {
        return "ImageI/O-Ext GDAL Coverage Extension";
    }

    public Optional<String> getVersion() {
        Version v = GeoTools.getVersion(GDALUtilities.class);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(v.toString());
    }

    public boolean isAvailable() {
        return GDALUtilities.isGDALAvailable();
    }

    public boolean isEnabled() {
        return true;
    }

    public Optional<String> getMessage() {
        String message = "JNI GDAL Wrapper Version: " + this.getGDALWrapperJarVersion().orElse("null");
        message = !this.isAvailable() ? message + "\njava.library.path: " + System.getProperty("java.library.path", "") : message + this.metaData();
        return Optional.ofNullable(message);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable("");
    }

    public Optional<String> getGDALWrapperJarVersion() {
        if (this.isAvailable()) {
            Version v = GeoTools.getVersion(gdal.class);
            if (v == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(v.toString());
        }
        return Optional.ofNullable("unavailable");
    }

    String metaData() {
        StringBuffer msg = new StringBuffer();
        msg.append("\nGDAL Version: " + gdal.VersionInfo((String)"RELEASE_NAME"));
        msg.append("\nGDAL Release Date: " + gdal.VersionInfo((String)"RELEASE_DATE"));
        msg.append("\nGDAL Build Info: " + gdal.VersionInfo((String)"BUILD_INFO"));
        return msg.toString();
    }
}

