/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.css.web;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Page;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyleEditCssRecoveryTest
extends GeoServerWicketTestSupport {
    String oldCssStyle = "OldCssStyle";
    String oldCssStyleWithFormatSLD = "OldCssStyle_Format_Set_To_SLD";
    String oldCssStyleWithSLDManuallyEdited = "OldCssStyle_SLD_Manually_Edited";
    Catalog catalog;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        Date t0 = new Date(1483228800000L);
        List<String> testStyleNames = Arrays.asList(this.oldCssStyle, this.oldCssStyleWithFormatSLD, this.oldCssStyleWithSLDManuallyEdited);
        for (String styleName : testStyleNames) {
            for (String ext : Arrays.asList(".css", ".sld", ".xml")) {
                testData.copyTo(((Object)((Object)this)).getClass().getResourceAsStream(styleName + ext), "styles/" + styleName + ext);
                File f = Paths.get(testData.getDataDirectoryRoot().getAbsolutePath(), "styles/" + styleName + ext).toFile();
                f.setLastModified(t0.getTime());
            }
        }
        File manuallyEditedSld = Paths.get(testData.getDataDirectoryRoot().getAbsolutePath(), "styles/" + this.oldCssStyleWithSLDManuallyEdited + ".sld").toFile();
        manuallyEditedSld.setLastModified(t0.getTime() + 1000000L);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setUp() throws Exception {
        this.login();
        this.catalog = this.getCatalog();
    }

    @Test
    public void testRecoverLostCssStyle() throws Exception {
        StyleInfo styleInfo = this.catalog.getStyleByName(this.oldCssStyle);
        StyleEditPage edit = new StyleEditPage(styleInfo);
        tester.startPage((Page)edit);
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("styleForm:context:panel:format", (Object)"css");
        String editorContents = (String)tester.getComponentFromLastRenderedPage("styleForm:styleEditor:editorContainer:editorParent:editor").getDefaultModelObject();
        Styles.handler((String)"css").parse((Object)editorContents, null, null, null);
        StyleInfo si = this.catalog.getStyleByName(this.oldCssStyle);
        Assert.assertEquals((Object)"css", (Object)si.getFormat());
        Assert.assertEquals((Object)(this.oldCssStyle + ".css"), (Object)si.getFilename());
    }

    @Test
    public void testRecoverLostCssStyleWithFormatSetToSLD() throws Exception {
        StyleInfo styleInfo = this.catalog.getStyleByName(this.oldCssStyleWithFormatSLD);
        StyleEditPage edit = new StyleEditPage(styleInfo);
        tester.startPage((Page)edit);
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("styleForm:context:panel:format", (Object)"css");
        String editorContents = (String)tester.getComponentFromLastRenderedPage("styleForm:styleEditor:editorContainer:editorParent:editor").getDefaultModelObject();
        Styles.handler((String)"css").parse((Object)editorContents, null, null, null);
        StyleInfo si = this.catalog.getStyleByName(this.oldCssStyleWithFormatSLD);
        Assert.assertEquals((Object)"css", (Object)si.getFormat());
        Assert.assertEquals((Object)(this.oldCssStyleWithFormatSLD + ".css"), (Object)si.getFilename());
    }

    @Test
    public void testIgnoreCssStyleIfSLDWasEdited() throws Exception {
        StyleInfo styleInfo = this.catalog.getStyleByName(this.oldCssStyleWithSLDManuallyEdited);
        StyleEditPage edit = new StyleEditPage(styleInfo);
        tester.startPage((Page)edit);
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("styleForm:context:panel:format", (Object)"sld");
        String editorContents = (String)tester.getComponentFromLastRenderedPage("styleForm:styleEditor:editorContainer:editorParent:editor").getDefaultModelObject();
        Styles.handler((String)"sld").parse((Object)editorContents, null, null, null);
        StyleInfo si = this.catalog.getStyleByName(this.oldCssStyleWithSLDManuallyEdited);
        Assert.assertEquals((Object)"sld", (Object)si.getFormat());
        Assert.assertEquals((Object)(this.oldCssStyleWithSLDManuallyEdited + ".sld"), (Object)si.getFilename());
    }
}

