/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.css.web;

import java.io.IOException;
import org.geoserver.catalog.Styles;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.styling.SLD;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CssHandlerTest
extends GeoServerSystemTestSupport {
    @Test
    public void testParseThroughStyles() throws IOException {
        String css = "* { fill: lightgrey; }";
        StyledLayerDescriptor sld = Styles.handler((String)"css").parse((Object)css, null, null, null);
        Assert.assertNotNull((Object)sld);
        PolygonSymbolizer ps = SLD.polySymbolizer((Style)Styles.style((StyledLayerDescriptor)sld));
        Assert.assertNotNull((Object)ps);
    }

    @Test
    public void testParseMultiLayer() throws IOException {
        String css = "topp:states {fill:gray} sf:roads {stroke:black}";
        StyledLayerDescriptor sld = Styles.handler((String)"css").parse((Object)css, null, null, null);
        Assert.assertNotNull((Object)sld);
        Assert.assertEquals((long)2L, (long)sld.getStyledLayers().length);
        NamedLayer l1 = (NamedLayer)sld.getStyledLayers()[0];
        Assert.assertEquals((Object)"topp:states", (Object)l1.getName());
        Assert.assertEquals((long)1L, (long)l1.getStyles().length);
        FeatureTypeStyle fts1 = (FeatureTypeStyle)l1.getStyles()[0].featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fts1.featureTypeNames(), (Matcher)Matchers.empty());
        PolygonSymbolizer poly = SLD.polySymbolizer((FeatureTypeStyle)fts1);
        Assert.assertEquals((Object)"#808080", (Object)poly.getFill().getColor().evaluate(null, String.class));
        NamedLayer l2 = (NamedLayer)sld.getStyledLayers()[1];
        Assert.assertEquals((Object)"sf:roads", (Object)l2.getName());
        Assert.assertEquals((long)1L, (long)l2.getStyles().length);
        FeatureTypeStyle fts2 = (FeatureTypeStyle)l2.getStyles()[0].featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fts2.featureTypeNames(), (Matcher)Matchers.empty());
        LineSymbolizer line = SLD.lineSymbolizer((FeatureTypeStyle)fts2);
        Assert.assertEquals((Object)"#000000", (Object)line.getStroke().getColor().evaluate(null, String.class));
    }

    @Test
    public void testCssStyleIsAppliedToLayer() throws Exception {
        String wmsRequest = "wms?service=WMS&version=1.1.1&request=GetFeatureInfo&format=image/png&query_layers=sf:AggregateGeoFeature&layers=sf:AggregateGeoFeature&info_format=text/xml&feature_count=10&x=50&y=50&width=101&height=101&bbox=70.9,30.9,73.1,33.0";
        Document responseWithDefaultStyle = this.getAsDOM(wmsRequest);
        NodeList featuresWithDefaultStyle = responseWithDefaultStyle.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)0L, (long)featuresWithDefaultStyle.getLength());
        String css = "@styleName 'sf:AggregateGeoFeature'; *{mark: symbol(square); mark-size: 100px;}";
        Document responseWithCssStyle = this.getAsDOM(wmsRequest + "&style_format=css&style_body=" + css);
        NodeList featuresWithCssStyle = responseWithCssStyle.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)1L, (long)featuresWithCssStyle.getLength());
    }

    @Test
    public void testZoomLevelEquals() throws Exception {
        String css = "[@z = 10] {stroke: black}";
        StyledLayerDescriptor sld = Styles.handler((String)"css").parse((Object)css, null, null, null);
        Rule rule = (Rule)((FeatureTypeStyle)((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((double)543262.0, (double)rule.getMinScaleDenominator(), (double)1.0);
        Assert.assertEquals((double)1086524.0, (double)rule.getMaxScaleDenominator(), (double)1.0);
    }

    @Test
    public void testZoomLevelEqualsUTM32N() throws Exception {
        String css = "@tileMatrixSet 'UTM32WGS84Quad'; [@z = 10] {stroke: black}";
        StyledLayerDescriptor sld = Styles.handler((String)"css").parse((Object)css, null, null, null);
        Rule rule = (Rule)((FeatureTypeStyle)((NamedLayer)sld.getStyledLayers()[0]).getStyles()[0].featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((double)271176.0, (double)rule.getMinScaleDenominator(), (double)1.0);
        Assert.assertEquals((double)542352.0, (double)rule.getMaxScaleDenominator(), (double)1.0);
    }
}

