/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.namespace.NamespaceContext;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.style.Style;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;

public class CssStyleControllerTest
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;
    private static SimpleNamespaceContext namespaceContext;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
        namespaceContext = new SimpleNamespaceContext();
        namespaceContext.bindNamespaceUri("sld", "http://www.opengis.net/sld");
        namespaceContext.bindNamespaceUri("ogc", "http://www.opengis.net/ogc");
        testData.addStyle(catalog.getDefaultWorkspace(), "test", "test.css", CssStyleControllerTest.class, catalog, Collections.singletonMap(SystemTestData.StyleProperty.FORMAT, "css"));
        testData.addStyle(catalog.getDefaultWorkspace(), "multilayer", "multilayer.css", CssStyleControllerTest.class, catalog, Collections.singletonMap(SystemTestData.StyleProperty.FORMAT, "css"));
    }

    @Before
    public void login() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    @Test
    public void getGetAsCSS() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/" + catalog.getDefaultWorkspace().getName() + "/styles/test.css");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.geoserver.geocss+css", (Object)response.getContentType());
        String content = response.getContentAsString();
        Assert.assertEquals((Object)"* {stroke: red}", (Object)content);
    }

    @Test
    public void getGetAsSLD10() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/" + catalog.getDefaultWorkspace().getName() + "/styles/test.sld");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.ogc.sld+xml", (Object)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)"//sld:LineSymbolizer/sld:Stroke/sld:CssParameter", (NamespaceContext)namespaceContext, (Matcher)Matchers.equalTo((Object)"#ff0000")));
    }

    @Test
    public void getGetMultiLayerAsSLD10() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/" + catalog.getDefaultWorkspace().getName() + "/styles/multilayer.sld");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.ogc.sld+xml", (Object)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)"//sld:NamedLayer[1]/sld:Name", (NamespaceContext)namespaceContext, (Matcher)Matchers.equalTo((Object)"states")));
        MatcherAssert.assertThat((Object)dom, (Matcher)Matchers.hasXPath((String)"//sld:NamedLayer[2]/sld:Name", (NamespaceContext)namespaceContext, (Matcher)Matchers.equalTo((Object)"roads")));
    }

    @Test
    public void getGetAsHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/" + catalog.getDefaultWorkspace().getName() + "/styles/test.html");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)("<a href=\"http://localhost:8080/geoserver/rest/workspaces/" + catalog.getDefaultWorkspace().getName() + "/styles/test.css\">test.css</a>")));
    }

    @Test
    public void testRawPutCSS() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((String)"foo not available", (Object)cat.getStyleByName("foo"));
        String xml = "<style><name>foo</name><format>css</format><filename>foo.css</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)cat.getStyleByName("foo"));
        String content = this.newCSS();
        response = this.putAsServletResponse("/rest/styles/foo?raw=true", content, "application/vnd.geoserver.geocss+css");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        GeoServerResourceLoader resources = catalog.getResourceLoader();
        Resource resource = resources.get("/styles/foo.css");
        String definition = new String(resource.getContents());
        Assert.assertTrue((String)"is css", (boolean)definition.contains("stroke: red"));
        StyleInfo styleInfo = catalog.getStyleByName("foo");
        Style s = styleInfo.getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        content = new String(out.toByteArray());
        Assert.assertTrue((boolean)content.contains("<sld:Name>foo</sld:Name>"));
        catalog.remove(styleInfo);
    }

    @Test
    public void testPostCSS() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((String)"foo not available", (Object)cat.getStyleByName("foo"));
        String content = this.newCSS();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=foo", content, "application/vnd.geoserver.geocss+css");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        GeoServerResourceLoader resources = catalog.getResourceLoader();
        Resource resource = resources.get("/styles/foo.css");
        String definition = new String(resource.getContents());
        Assert.assertTrue((String)"is css", (boolean)definition.contains("stroke: red"));
        StyleInfo styleInfo = catalog.getStyleByName("foo");
        Style s = styleInfo.getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        content = new String(out.toByteArray());
        Assert.assertTrue((boolean)content.contains("<sld:Name>foo</sld:Name>"));
        catalog.remove(styleInfo);
    }

    @Test
    public void testPutCSS() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getStyleByName("bar"));
        String xml = "<style><name>bar</name><format>css</format><filename>bar.css</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)cat.getStyleByName("bar"));
        String content = this.newCSS();
        response = this.putAsServletResponse("/rest/styles/bar", content, "application/vnd.geoserver.geocss+css");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        GeoServerResourceLoader resources = catalog.getResourceLoader();
        Resource resource = resources.get("/styles/bar.css");
        String definition = new String(resource.getContents());
        Assert.assertTrue((String)"is css", (boolean)definition.contains("stroke: red"));
        StyleInfo styleInfo = catalog.getStyleByName("bar");
        Style s = styleInfo.getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        content = new String(out.toByteArray());
        Assert.assertTrue((boolean)content.contains("<sld:Name>bar</sld:Name>"));
        content = "* { outline: red}";
        response = this.putAsServletResponse("/rest/styles/bar", content, "application/vnd.geoserver.geocss+css");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        catalog.remove(styleInfo);
    }

    String newCSS() {
        return "* { stroke: red}";
    }
}

