/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import com.google.common.base.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.ControlFlowCallback;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class SingleQueueFlowController
implements FlowController {
    static final Logger LOGGER = Logging.getLogger(ControlFlowCallback.class);
    Predicate<Request> matcher;
    ThreadBlocker blocker;
    int controllerPriority;

    public SingleQueueFlowController(Predicate<Request> matcher, int controllerPriority, ThreadBlocker blocker) {
        this.controllerPriority = controllerPriority;
        this.matcher = matcher;
        this.blocker = blocker;
    }

    @Override
    public int getPriority() {
        return this.controllerPriority;
    }

    @Override
    public void requestComplete(Request request) {
        if (this.matcher.apply((Object)request)) {
            this.blocker.requestComplete(request);
        }
    }

    @Override
    public boolean requestIncoming(Request request, long timeout) {
        boolean retval = true;
        if (this.matcher.apply((Object)request)) {
            try {
                retval = this.blocker.requestIncoming(request, timeout);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Unexpected interruption while waiting for execution");
            }
        }
        return retval;
    }

    public Predicate<Request> getMatcher() {
        return this.matcher;
    }

    public int getRequestsInQueue() {
        return this.blocker.getRunningRequestsCount();
    }

    public ThreadBlocker getBlocker() {
        return this.blocker;
    }
}

