/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.controller.PriorityProvider;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class PriorityThreadBlocker
implements ThreadBlocker {
    static final Logger LOGGER = Logging.getLogger(PriorityThreadBlocker.class);
    private final PriorityProvider priorityProvider;
    private final int maxRunningRequests;
    private final PriorityQueue<WaitToken> queue = new PriorityQueue();
    private final Set<Request> runningQueue = new HashSet<Request>();

    public PriorityThreadBlocker(int queueSize, PriorityProvider priorityProvider) {
        this.maxRunningRequests = queueSize;
        this.priorityProvider = priorityProvider;
    }

    @Override
    public int getRunningRequestsCount() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestIncoming(Request request, long timeout) throws InterruptedException {
        WaitToken token = null;
        boolean result = false;
        PriorityThreadBlocker priorityThreadBlocker = this;
        synchronized (priorityThreadBlocker) {
            if (this.runningQueue.size() < this.maxRunningRequests) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Running requests at " + this.runningQueue.size() + ", no block");
                }
                result = true;
            } else {
                int priority = this.priorityProvider.getPriority(request);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Running requests at " + this.runningQueue.size() + ", Queuing request with priority " + priority);
                }
                token = new WaitToken(priority);
                this.queue.add(token);
            }
        }
        if (token != null) {
            if (timeout > 0L) {
                result = token.latch.await(timeout, TimeUnit.MILLISECONDS);
                priorityThreadBlocker = this;
                synchronized (priorityThreadBlocker) {
                    if (!result) {
                        boolean removed;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Request with priority " + token.priority + " timed out, removing from queue");
                        }
                        if (!(removed = this.queue.remove(token))) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "Request was not found in queue, releasing next");
                            }
                            if (this.runningQueue.size() < this.maxRunningRequests) {
                                this.releaseNext();
                            }
                        }
                    }
                }
            } else {
                token.latch.await();
                result = true;
            }
        }
        priorityThreadBlocker = this;
        synchronized (priorityThreadBlocker) {
            this.runningQueue.add(request);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestComplete(Request request) {
        PriorityThreadBlocker priorityThreadBlocker = this;
        synchronized (priorityThreadBlocker) {
            this.runningQueue.remove(request);
            if (this.runningQueue.size() < this.maxRunningRequests) {
                this.releaseNext();
            }
        }
    }

    private void releaseNext() {
        assert (Thread.holdsLock(this));
        WaitToken token = this.queue.poll();
        if (token != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Releasing request with priority " + token.priority);
            }
            token.latch.countDown();
        }
    }

    public PriorityProvider getPriorityProvider() {
        return this.priorityProvider;
    }

    public String toString() {
        return "PriorityBlocker(" + this.maxRunningRequests + ", " + this.priorityProvider + ")";
    }

    private static class WaitToken
    implements Comparable<WaitToken> {
        CountDownLatch latch = new CountDownLatch(1);
        long created = System.currentTimeMillis();
        int priority;

        public WaitToken(int priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(WaitToken o) {
            int diff = o.priority - this.priority;
            if (diff != 0) {
                return diff;
            }
            return Long.signum(this.created - o.created);
        }
    }
}

