/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import javax.servlet.http.Cookie;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.flow.controller.UserConcurrentFlowController;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class UserFlowControllerTest
extends AbstractFlowControllerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequestsSingleUser() {
        UserConcurrentFlowController controller = new UserConcurrentFlowController(1);
        Request firstRequest = this.buildCookieRequest(null);
        FlowControllerTestingThread tSample = new FlowControllerTestingThread(firstRequest, 0L, 0L, new FlowController[]{controller});
        tSample.start();
        this.waitTerminated(tSample, 60000L);
        Cookie cookie = ((MockHttpServletResponse)firstRequest.getHttpResponse()).getCookies()[0];
        String cookieValue = cookie.getValue();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildCookieRequest(cookieValue), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildCookieRequest(cookieValue), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t2.state));
            t2.interrupt();
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }
}

