/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.flow.controller.GlobalFlowController;
import org.geoserver.flow.controller.HttpHeaderPriorityProvider;
import org.geoserver.flow.controller.PriorityProvider;
import org.geoserver.flow.controller.PriorityThreadBlocker;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class PriorityFlowControllerTest
extends AbstractFlowControllerTest {
    static final String PRIORITY_HEADER_NAME = "priorityHeader";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleDelay() throws Exception {
        HttpHeaderPriorityProvider priorityProvider = new HttpHeaderPriorityProvider(PRIORITY_HEADER_NAME, 0);
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new PriorityThreadBlocker(1, (PriorityProvider)priorityProvider));
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildRequest(1), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildRequest(2), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t3 = new FlowControllerTestingThread(this.buildRequest(3), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            t3.start();
            this.waitBlocked(t3, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t3.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t3, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            t3.interrupt();
            this.waitTerminated(t3, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t3.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
            this.waitAndKill(t3, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFirstInFirstOut() throws Exception {
        HttpHeaderPriorityProvider priorityProvider = new HttpHeaderPriorityProvider(PRIORITY_HEADER_NAME, 0);
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new PriorityThreadBlocker(1, (PriorityProvider)priorityProvider));
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildRequest(1), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildRequest(1), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t3 = new FlowControllerTestingThread(this.buildRequest(1), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            t3.start();
            this.waitBlocked(t3, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t3.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t3.state));
            t2.interrupt();
            this.waitTerminated(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t2.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t3, 60000L);
            t2.interrupt();
            t3.interrupt();
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
            this.waitAndKill(t3, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() {
        HttpHeaderPriorityProvider priorityProvider = new HttpHeaderPriorityProvider(PRIORITY_HEADER_NAME, 0);
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new PriorityThreadBlocker(1, (PriorityProvider)priorityProvider));
        CountDownLatch latch = new CountDownLatch(1);
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildRequest(1), 100L, 400L, new FlowController[]{controller});
        t1.setWaitLatch(latch);
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildRequest(2), 100L, 400L, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            latch.countDown();
            this.waitTerminated(t1, 60000L);
            this.waitTerminated(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.TIMED_OUT), (Object)((Object)t2.state));
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }

    private Request buildRequest(Integer priority) {
        Request request = new Request();
        MockHttpServletRequest hr = new MockHttpServletRequest();
        if (priority != null) {
            hr.addHeader(PRIORITY_HEADER_NAME, (Object)String.valueOf(priority));
        }
        request.setHttpRequest((HttpServletRequest)hr);
        return request;
    }
}

