/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.flow.controller.IpFlowController;
import org.geoserver.flow.controller.UserConcurrentFlowController;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;

public class IpFlowControllerTest
extends AbstractFlowControllerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequestsSingleIPAddress() {
        IpFlowController controller = new IpFlowController(1);
        String ipAddress = "127.0.0.1";
        Request firstRequest = this.buildIpRequest(ipAddress, "");
        FlowControllerTestingThread tSample = new FlowControllerTestingThread(firstRequest, 0L, 0L, new FlowController[]{controller});
        tSample.start();
        this.waitTerminated(tSample, 60000L);
        Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)tSample.state));
        String ip = firstRequest.getHttpRequest().getRemoteAddr();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserAndIPAddressFlowControl() {
        IpFlowController ipController = new IpFlowController(1);
        UserConcurrentFlowController userController = new UserConcurrentFlowController(1);
        String ipAddress = "127.0.0.1";
        Request firstRequest = this.buildIpRequest(ipAddress, "");
        FlowControllerTestingThread tSample = new FlowControllerTestingThread(firstRequest, 0L, 0L, new FlowController[]{userController, ipController});
        tSample.start();
        this.waitTerminated(tSample, 60000L);
        Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)tSample.state));
        String ip = firstRequest.getHttpRequest().getRemoteAddr();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{ipController});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildIpRequest(ip, ""), 0L, Long.MAX_VALUE, new FlowController[]{ipController});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
            this.waitTerminated(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t2.state));
        }
        catch (Exception exception) {
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentProxiedIPAddresses() {
        IpFlowController controller = new IpFlowController(1);
        String ipAddress = "192.168.1.1";
        Request firstRequest = this.buildIpRequest(ipAddress, "");
        String ip = firstRequest.getHttpRequest().getRemoteAddr();
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(this.buildIpRequest(ip, "192.168.1.2"), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(this.buildIpRequest(ip, "192.168.1.3"), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t2.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            t2.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }
}

