/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.CountDownLatch;
import org.geoserver.flow.FlowController;
import org.geoserver.ows.Request;

public class FlowControllerTestingThread
extends Thread {
    FlowController[] controllers;
    boolean proceed;
    Request request;
    long timeout;
    long processingDelay;
    ThreadState state;
    Throwable error;
    CountDownLatch waitLatch;

    public FlowControllerTestingThread(Request request, long timeout, long processingDelay, FlowController ... controllers) {
        this.controllers = controllers;
        this.request = request;
        this.timeout = timeout;
        this.processingDelay = processingDelay;
    }

    public void setWaitLatch(CountDownLatch waitLatch) {
        this.waitLatch = waitLatch;
    }

    @Override
    public void run() {
        this.state = ThreadState.STARTED;
        try {
            for (FlowController controller : this.controllers) {
                if (controller.requestIncoming(this.request, this.timeout)) continue;
                this.state = ThreadState.TIMED_OUT;
                return;
            }
        }
        catch (Throwable t) {
            this.error = t;
        }
        this.state = ThreadState.PROCESSING;
        try {
            if (this.waitLatch != null) {
                this.waitLatch.await();
            }
            if (this.processingDelay > 0L) {
                FlowControllerTestingThread.sleep(this.processingDelay);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            for (FlowController controller : this.controllers) {
                controller.requestComplete(this.request);
            }
        }
        catch (Throwable t) {
            this.error = t;
        }
        this.state = ThreadState.COMPLETE;
    }

    static enum ThreadState {
        STARTED,
        TIMED_OUT,
        PROCESSING,
        COMPLETE;

    }
}

