/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.awaitility.Awaitility;
import org.geoserver.flow.controller.CookieKeyGenerator;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class AbstractFlowControllerTest {
    protected static final long MAX_WAIT = 60000L;

    void waitBlocked(Thread t, long maxWait) {
        Awaitility.await().atMost(maxWait, TimeUnit.MILLISECONDS).pollDelay(10L, TimeUnit.MILLISECONDS).until(() -> t.getState() == Thread.State.WAITING || t.getState() == Thread.State.TIMED_WAITING);
    }

    void waitTerminated(Thread t, long maxWait) {
        Awaitility.await().atMost(maxWait, TimeUnit.MILLISECONDS).pollDelay(10L, TimeUnit.MILLISECONDS).until(() -> t.getState() == Thread.State.TERMINATED);
    }

    void waitAndKill(Thread t, long maxWait) {
        try {
            long start = System.currentTimeMillis();
            while (t.isAlive()) {
                if (System.currentTimeMillis() > start + maxWait) {
                    t.interrupt();
                }
                Thread.sleep(20L);
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Sometime interrupeted our wait: " + e));
        }
    }

    protected Request buildCookieRequest(String gsCookieValue) {
        Request request = new Request();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        request.setHttpRequest((HttpServletRequest)httpRequest);
        request.setHttpResponse((HttpServletResponse)new MockHttpServletResponse());
        if (gsCookieValue != null) {
            httpRequest.setCookies(new Cookie[]{new Cookie(CookieKeyGenerator.COOKIE_NAME, gsCookieValue)});
        }
        return request;
    }

    Request buildIpRequest(String ipAddress, String proxyIp) {
        Request request = new Request();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        request.setHttpRequest((HttpServletRequest)httpRequest);
        request.setHttpResponse((HttpServletResponse)new MockHttpServletResponse());
        if (ipAddress != null && !ipAddress.equals("")) {
            httpRequest.setRemoteAddr(ipAddress);
        } else {
            httpRequest.setRemoteAddr("127.0.0.1");
        }
        if (!proxyIp.equals("")) {
            httpRequest.addHeader("x-forwarded-for", (Object)(proxyIp + ", " + ipAddress));
        }
        return request;
    }

    protected void waitState(FlowControllerTestingThread.ThreadState state, FlowControllerTestingThread tt, long maxWait) {
        Awaitility.await().atMost(maxWait, TimeUnit.MILLISECONDS).pollDelay(20L, TimeUnit.MILLISECONDS).until(() -> state.equals((Object)tt.state));
    }
}

