/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.Request;

public class SimpleThreadBlocker
implements ThreadBlocker {
    BlockingQueue<Request> queue;
    private final int queueSize;

    public SimpleThreadBlocker(int queueSize) {
        this.queueSize = queueSize;
        this.queue = new ArrayBlockingQueue<Request>(queueSize, true);
    }

    @Override
    public void requestComplete(Request request) {
        this.queue.remove(request);
    }

    @Override
    public int getRunningRequestsCount() {
        return this.queue.size();
    }

    @Override
    public boolean requestIncoming(Request request, long timeout) throws InterruptedException {
        if (timeout > 0L) {
            return this.queue.offer(request, timeout, TimeUnit.MILLISECONDS);
        }
        this.queue.put(request);
        return true;
    }

    public String toString() {
        return "SimpleBlocker(" + this.queueSize + ")";
    }
}

