/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.flow.ControlFlowCallback;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.KeyGenerator;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Request;
import org.geotools.util.CanonicalSet;
import org.geotools.util.logging.Logging;

public class RateFlowController
implements FlowController {
    public static final String X_RATE_LIMIT_RESET = "X-Rate-Limit-Reset";
    public static final String X_RATE_LIMIT_REMAINING = "X-Rate-Limit-Remaining";
    public static final String X_RATE_LIMIT_LIMIT = "X-Rate-Limit-Limit";
    public static final String X_RATE_LIMIT_CONTEXT = "X-Rate-Limit-Context";
    static final Logger LOGGER = Logging.getLogger(ControlFlowCallback.class);
    static int COUNTERS_CLEANUP_THRESHOLD = Integer.parseInt(System.getProperty("org.geoserver.flow.countersCleanupThreshold", "200"));
    static int COUNTERS_CLEANUP_INTERVAL = Integer.parseInt(System.getProperty("org.geoserver.flow.countersCleanupInterval", "10000"));
    static ThreadLocal<String> USER_ID = new ThreadLocal();
    KeyGenerator keyGenerator;
    Map<String, Counter> counters = new ConcurrentHashMap<String, Counter>();
    CanonicalSet<String> canonicalizer = CanonicalSet.newInstance(String.class);
    Predicate<Request> matcher;
    int maxRequests;
    long timeInterval;
    long delay;
    String action;
    volatile long lastCleanup = System.currentTimeMillis();

    public RateFlowController(Predicate<Request> matcher, int maxRequests, long timeInterval, long delay, KeyGenerator keyGenerator) {
        this.matcher = matcher;
        this.maxRequests = maxRequests;
        this.timeInterval = timeInterval;
        this.delay = delay;
        this.keyGenerator = keyGenerator;
        this.action = delay > 0L ? "Delay excess requests " + delay + "ms" : "Reject excess requests";
    }

    @Override
    public void requestComplete(Request request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestIncoming(Request request, long timeout) {
        if (!this.matcher.apply((Object)request)) {
            return true;
        }
        boolean retval = true;
        long now = System.currentTimeMillis();
        long currPeriodId = now / this.timeInterval;
        String userKey = this.keyGenerator.getUserKey(request);
        Counter counter = this.counters.get(userKey);
        if (counter == null) {
            String string = userKey = (String)this.canonicalizer.unique((Object)userKey);
            synchronized (string) {
                counter = this.counters.get(userKey);
                if (counter == null) {
                    counter = new Counter();
                    this.counters.put(userKey, counter);
                }
            }
        }
        int requests = counter.addRequest(currPeriodId);
        int residual = this.maxRequests - requests;
        HttpServletResponse response = request.getHttpResponse();
        response.addHeader(X_RATE_LIMIT_CONTEXT, this.matcher.toString());
        response.addIntHeader(X_RATE_LIMIT_LIMIT, this.maxRequests);
        response.addIntHeader(X_RATE_LIMIT_REMAINING, Math.max(residual, 0));
        response.addDateHeader(X_RATE_LIMIT_RESET, (currPeriodId + 1L) * this.timeInterval);
        response.addHeader("X-Rate-Limit-Action", this.action);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this + ", residual in current time period " + residual);
        }
        if (residual < 0) {
            if (this.delay <= 0L) {
                throw new HttpErrorCodeException(429, "Too many requests requests in the current time period, check X-Rate-Limit HTTP response headers");
            }
            if (this.delay > timeout) {
                return false;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + ", delaying current request");
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, this + ", the delay was abruptly interrupted", e);
            }
        }
        long elapsed = now - this.lastCleanup;
        if (this.counters.size() > COUNTERS_CLEANUP_THRESHOLD && (elapsed > this.timeInterval || elapsed > 10000L)) {
            int cleanupCount = 0;
            RateFlowController rateFlowController = this;
            synchronized (rateFlowController) {
                for (Map.Entry<String, Counter> entry : this.counters.entrySet()) {
                    Counter c = entry.getValue();
                    long timePeriodId = c.getTimePeriodId();
                    long age = (currPeriodId - timePeriodId) * this.timeInterval;
                    if (age <= (long)COUNTERS_CLEANUP_THRESHOLD) continue;
                    this.counters.remove(entry.getKey());
                }
                this.lastCleanup = now;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this + ", purged " + cleanupCount + " stale counters");
                }
            }
        }
        return retval;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public Predicate<Request> getMatcher() {
        return this.matcher;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE + this.maxRequests * (int)(86400L / this.timeInterval);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.matcher + ", action=" + this.action + "]";
    }

    final class Counter {
        volatile long timePeriodId;
        AtomicInteger requests = new AtomicInteger(0);

        Counter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRequest(long currPeriodId) {
            if (currPeriodId != this.timePeriodId) {
                Counter counter = this;
                synchronized (counter) {
                    if (currPeriodId != this.timePeriodId) {
                        this.timePeriodId = currPeriodId;
                        this.requests.set(0);
                    }
                }
            }
            return this.requests.incrementAndGet();
        }

        public synchronized long getTimePeriodId() {
            return this.timePeriodId;
        }
    }
}

