/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.FlowController;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public abstract class QueueController
implements FlowController {
    private static final Logger LOGGER = Logging.getLogger(QueueController.class);
    int queueMaxSize;
    Map<String, TimedBlockingQueue> queues = new ConcurrentHashMap<String, TimedBlockingQueue>();
    long lastCleanup = System.currentTimeMillis();
    int maxQueues = 100;
    int maxAge = 10000;

    @Override
    public boolean requestIncoming(Request request, long timeout) {
        return false;
    }

    @Override
    public int getPriority() {
        return this.queueMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpQueues(long now) {
        int queuesSize = this.queues.size();
        if (queuesSize > this.maxQueues && now - this.lastCleanup > (long)(this.maxAge / 10) || now - this.lastCleanup > (long)this.maxAge) {
            int cleanupCount = 0;
            QueueController queueController = this;
            synchronized (queueController) {
                for (String key : this.queues.keySet()) {
                    TimedBlockingQueue tbq = this.queues.get(key);
                    if (now - tbq.lastModified <= (long)this.maxAge || !tbq.isEmpty()) continue;
                    this.queues.remove(key);
                    ++cleanupCount;
                }
                this.lastCleanup = now;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this.getClass().getSimpleName() + "(" + this.queueMaxSize + ") purged " + cleanupCount + " stale queues out of " + queuesSize);
                }
            }
        }
    }

    protected static class TimedBlockingQueue
    extends ArrayBlockingQueue<Request> {
        long lastModified;

        public TimedBlockingQueue(int capacity, boolean fair) {
            super(capacity, fair);
        }

        @Override
        public void put(Request o) throws InterruptedException {
            super.put(o);
            this.lastModified = System.currentTimeMillis();
        }

        @Override
        public boolean remove(Object o) {
            this.lastModified = System.currentTimeMillis();
            return super.remove(o);
        }
    }
}

