/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import com.google.common.base.Predicate;
import org.geoserver.ows.Request;

public class OWSRequestMatcher
implements Predicate<Request> {
    String service;
    String method;
    String outputFormat;

    public OWSRequestMatcher() {
        this(null, null, null);
    }

    public OWSRequestMatcher(String service) {
        this(service, null, null);
    }

    public OWSRequestMatcher(String service, String method) {
        this(service, method, null);
    }

    public OWSRequestMatcher(String service, String method, String outputFormat) {
        this.service = service;
        this.method = method;
        this.outputFormat = outputFormat;
        if (service == null && (method != null || outputFormat != null)) {
            throw new IllegalArgumentException("Invalid OWS definition, service cannot be non null when method or output format are provided");
        }
        if (method == null && outputFormat != null) {
            throw new IllegalArgumentException("Invalid OWS definition, output format cannot be valued if method is not provided");
        }
    }

    public String toString() {
        if (this.service == null) {
            return "Any OGC request";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.service);
        if (this.method != null) {
            sb.append(".").append(this.method);
            if (this.outputFormat != null) {
                sb.append(".=").append(this.outputFormat);
            }
        }
        return sb.toString();
    }

    public boolean apply(Request request) {
        if (this.service == null) {
            return true;
        }
        if (!this.service.equalsIgnoreCase(request.getService())) {
            return false;
        }
        if (this.method == null) {
            return true;
        }
        if (!this.method.equalsIgnoreCase(request.getRequest())) {
            return false;
        }
        if (this.outputFormat == null) {
            return true;
        }
        return this.outputFormat.equalsIgnoreCase(request.getOutputFormat());
    }

    public String getService() {
        return this.service;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.outputFormat == null ? 0 : this.outputFormat.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OWSRequestMatcher other = (OWSRequestMatcher)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.outputFormat == null ? other.outputFormat != null : !this.outputFormat.equals(other.outputFormat)) {
            return false;
        }
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }
}

