/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import com.google.common.base.Predicate;
import org.geoserver.flow.controller.IpFlowController;
import org.geoserver.ows.Request;

public class IpRequestMatcher
implements Predicate<Request> {
    private final String ip;

    public IpRequestMatcher(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean apply(Request request) {
        String incomingIp = IpFlowController.getRemoteAddr(request.getHttpRequest());
        boolean matches = this.ip.equals(incomingIp);
        return matches;
    }

    public String toString() {
        return "ip=" + this.ip;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpRequestMatcher other = (IpRequestMatcher)obj;
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }
}

