/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.controller.PriorityProvider;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class HttpHeaderPriorityProvider
implements PriorityProvider {
    static final Logger LOGGER = Logging.getLogger(HttpHeaderPriorityProvider.class);
    private final String headerName;
    private final int defaultPriority;

    public HttpHeaderPriorityProvider(String headerName, int defaultPriority) {
        this.headerName = headerName;
        this.defaultPriority = defaultPriority;
    }

    @Override
    public int getPriority(Request request) {
        if (request != null && request.getHttpRequest() != null && request.getHttpRequest().getHeader(this.headerName) != null) {
            String priorityString = request.getHttpRequest().getHeader(this.headerName);
            try {
                int priority = Integer.parseInt(priorityString);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Found priority header " + this.headerName + " in request with value " + priority);
                }
                return priority;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "Priority header found, but did not have a valid integer value", e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Did not find priority header " + this.headerName + " in request, using default priorirty");
        }
        return this.defaultPriority;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public String toString() {
        return "HttpHeaderPriorityProvider(" + this.headerName + "," + this.defaultPriority + ")";
    }
}

