/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.config.GeoServerPluginConfigurator;
import org.geoserver.flow.ControlFlowConfigurator;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.config.Intervals;
import org.geoserver.flow.controller.BasicOWSController;
import org.geoserver.flow.controller.CookieKeyGenerator;
import org.geoserver.flow.controller.GlobalFlowController;
import org.geoserver.flow.controller.HttpHeaderPriorityProvider;
import org.geoserver.flow.controller.IpFlowController;
import org.geoserver.flow.controller.IpKeyGenerator;
import org.geoserver.flow.controller.KeyGenerator;
import org.geoserver.flow.controller.OWSRequestMatcher;
import org.geoserver.flow.controller.PriorityProvider;
import org.geoserver.flow.controller.PriorityThreadBlocker;
import org.geoserver.flow.controller.RateFlowController;
import org.geoserver.flow.controller.SimpleThreadBlocker;
import org.geoserver.flow.controller.SingleIpFlowController;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.flow.controller.UserConcurrentFlowController;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;

public class DefaultControlFlowConfigurator
implements ControlFlowConfigurator,
GeoServerPluginConfigurator {
    static final Pattern RATE_PATTERN = Pattern.compile("(\\d+)/([smhd])(;(\\d+)s)?");
    static final Logger LOGGER = Logging.getLogger(DefaultControlFlowConfigurator.class);
    static final String PROPERTYFILENAME = "controlflow.properties";
    PropertyFileWatcher configFile;
    long timeout = -1L;

    public DefaultControlFlowConfigurator() {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource controlflow = loader.get(PROPERTYFILENAME);
        this.configFile = new PropertyFileWatcher(controlflow);
    }

    DefaultControlFlowConfigurator(PropertyFileWatcher watcher) {
        this.configFile = watcher;
    }

    public List<FlowController> buildFlowControllers() throws Exception {
        this.timeout = -1L;
        Properties p = this.configFile.getProperties();
        ArrayList<FlowController> newControllers = new ArrayList<FlowController>();
        PriorityProvider priorityProvider = this.getPriorityProvider(p);
        for (Object okey : p.keySet()) {
            int queueSize;
            String[] keys;
            String value;
            String key;
            block25: {
                key = ((String)okey).trim();
                value = (String)p.get(okey);
                keys = key.split("\\s*\\.\\s*");
                queueSize = 0;
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                try {
                    if ("ip.blacklist".equals(key) || "ip.whitelist".equals(key) || "ows.priority.http".equals(key)) continue;
                    if (key.startsWith("user.ows") || key.startsWith("ip.ows")) break block25;
                    queueSize = tokenizer.countTokens() == 1 ? Integer.parseInt(value) : Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException e) {
                    LOGGER.severe("Rules should be assigned just a queue size, instead " + key + " is associated to " + value);
                    continue;
                }
            }
            FlowController controller = null;
            if ("timeout".equalsIgnoreCase(key)) {
                this.timeout = queueSize * 1000;
                continue;
            }
            if ("ows.global".equalsIgnoreCase(key)) {
                controller = new GlobalFlowController(queueSize, this.buildBlocker(queueSize, priorityProvider));
            } else if ("ows".equals(keys[0])) {
                ThreadBlocker threadBlocker = this.buildBlocker(queueSize, priorityProvider);
                if (keys.length >= 4) {
                    controller = new BasicOWSController(keys[1], keys[2], keys[3], queueSize, threadBlocker);
                } else if (keys.length == 3) {
                    controller = new BasicOWSController(keys[1], keys[2], queueSize, threadBlocker);
                } else if (keys.length == 2) {
                    controller = new BasicOWSController(keys[1], queueSize, threadBlocker);
                }
            } else if ("user".equals(keys[0])) {
                if (keys.length == 1) {
                    controller = new UserConcurrentFlowController(queueSize);
                } else if ("ows".equals(keys[1])) {
                    controller = new RateControllerBuilder(){

                        @Override
                        protected KeyGenerator buildKeyGenerator(String[] keys, String value) {
                            return new CookieKeyGenerator();
                        }
                    }.build(keys, value);
                }
            } else if ("ip".equals(keys[0])) {
                if (keys.length == 1) {
                    controller = new IpFlowController(queueSize);
                } else if (keys.length > 1 && "ows".equals(keys[1])) {
                    controller = new RateControllerBuilder(){

                        @Override
                        protected KeyGenerator buildKeyGenerator(String[] keys, String value) {
                            return new IpKeyGenerator();
                        }
                    }.build(keys, value);
                } else if (keys.length > 1 && !"blacklist".equals(keys[1]) && !"whitelist".equals(keys[1])) {
                    String ip = key.substring("ip.".length());
                    controller = new SingleIpFlowController(queueSize, ip);
                }
            }
            if (controller == null) {
                LOGGER.severe("Could not parse control-flow rule: '" + okey + "=" + value);
                continue;
            }
            LOGGER.info("Loaded control-flow rule: " + key + "=" + value);
            newControllers.add(controller);
        }
        return newControllers;
    }

    private PriorityProvider getPriorityProvider(Properties p) {
        for (Object okey : p.keySet()) {
            String key = ((String)okey).trim();
            String value = (String)p.get(okey);
            if (!"ows.priority.http".equals(key)) continue;
            Object error = "";
            try {
                String[] splitValue = value.trim().split("\\s*,\\s*");
                if (splitValue.length == 2 && splitValue[0].length() > 0) {
                    String httpHeaderName = splitValue[0];
                    int defaultPriority = Integer.parseInt(splitValue[1]);
                    LOGGER.info("Found OWS priority specification " + key + "=" + value);
                    return new HttpHeaderPriorityProvider(httpHeaderName, defaultPriority);
                }
            }
            catch (NumberFormatException e) {
                error = " " + e.getMessage();
            }
            LOGGER.severe("Unexpected priority specification found '" + value + "', the expected format is headerName,defaultPriorityValue." + (String)error);
        }
        return null;
    }

    private ThreadBlocker buildBlocker(int queueSize, PriorityProvider priorityProvider) {
        if (priorityProvider != null) {
            return new PriorityThreadBlocker(queueSize, priorityProvider);
        }
        return new SimpleThreadBlocker(queueSize);
    }

    @Override
    public boolean isStale() {
        return this.configFile.isStale();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public List<Resource> getFileLocations() throws IOException {
        ArrayList<Resource> configurationFiles = new ArrayList<Resource>();
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        if (loader != null) {
            Resource controlflow = loader.get(PROPERTYFILENAME);
            configurationFiles.add(controlflow);
        } else if (this.configFile != null && this.configFile.getResource() != null) {
            configurationFiles.add(this.configFile.getResource());
        }
        return configurationFiles;
    }

    public void saveConfiguration(GeoServerResourceLoader resourceLoader) throws IOException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        if (loader != null) {
            for (Resource controlflow : this.getFileLocations()) {
                Resource targetDir = Files.asResource((File)resourceLoader.findOrCreateDirectory(Paths.convert((File)loader.getBaseDirectory(), (File)controlflow.parent().dir())));
                Resources.copy((File)controlflow.file(), (Resource)targetDir);
            }
        } else if (this.configFile != null && this.configFile.getResource() != null) {
            Resources.copy((File)this.configFile.getFile(), (Resource)Files.asResource((File)resourceLoader.getBaseDirectory()));
        } else if (this.configFile != null && this.configFile.getProperties() != null) {
            File controlFlowConfigurationFile = Resources.file((Resource)resourceLoader.get(PROPERTYFILENAME), (boolean)true);
            try (OutputStream out = Files.out((File)controlFlowConfigurationFile);){
                this.configFile.getProperties().store(out, "");
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(GeoServerResourceLoader resourceLoader) throws IOException {
        DefaultControlFlowConfigurator defaultControlFlowConfigurator = this;
        synchronized (defaultControlFlowConfigurator) {
            Resource controlflow = resourceLoader.get(PROPERTYFILENAME);
            if (Resources.exists((Resource)controlflow)) {
                this.configFile = new PropertyFileWatcher(controlflow);
            }
        }
    }

    static abstract class RateControllerBuilder {
        RateControllerBuilder() {
        }

        public FlowController build(String[] keys, String value) {
            Matcher matcher = RATE_PATTERN.matcher(value);
            if (!matcher.matches()) {
                LOGGER.severe("Rate limiting rule values should be expressed as <rate</<unit>[;<delay>s], where unit can be s, m, h or d. This one is invalid: " + value);
                return null;
            }
            int rate = Integer.parseInt(matcher.group(1));
            long interval = Intervals.valueOf((String)matcher.group((int)2)).duration;
            int delay = 0;
            String userDelay = matcher.group(4);
            if (userDelay != null) {
                delay = Integer.parseInt(userDelay) * 1000;
            }
            String service = keys.length >= 3 ? keys[2] : null;
            String request = keys.length >= 4 ? keys[3] : null;
            String format = keys.length >= 5 ? keys[4] : null;
            OWSRequestMatcher requestMatcher = new OWSRequestMatcher(service, request, format);
            KeyGenerator keyGenerator = this.buildKeyGenerator(keys, value);
            return new RateFlowController(requestMatcher, rate, interval, delay, keyGenerator);
        }

        protected abstract KeyGenerator buildKeyGenerator(String[] var1, String var2);
    }
}

