/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.ControlFlowCallback;
import org.geoserver.flow.ControlFlowConfigurator;
import org.geoserver.flow.ControllerPriorityComparator;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.FlowControllerProvider;
import org.geoserver.flow.config.DefaultControlFlowConfigurator;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

public class DefaultFlowControllerProvider
implements FlowControllerProvider {
    static final Logger LOGGER = Logging.getLogger(ControlFlowCallback.class);
    ControlFlowConfigurator configurator;
    List<FlowController> controllers = Collections.emptyList();
    private long timeout;

    public DefaultFlowControllerProvider(ApplicationContext applicationContext) {
        this.configurator = (ControlFlowConfigurator)GeoServerExtensions.bean(ControlFlowConfigurator.class, (ApplicationContext)applicationContext);
        if (this.configurator == null) {
            this.configurator = new DefaultControlFlowConfigurator();
        }
        this.initControllers();
    }

    public DefaultFlowControllerProvider(ControlFlowConfigurator configurator) {
        this.configurator = configurator;
        this.initControllers();
    }

    private void initControllers() {
        this.checkConfiguration();
        if (this.controllers.isEmpty()) {
            LOGGER.config("Control-flow inactive, there are no configured rules");
        }
    }

    @Override
    public List<FlowController> getFlowControllers(Request request) throws Exception {
        this.checkConfiguration();
        return this.controllers;
    }

    @Override
    public long getTimeout(Request request) {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfiguration() {
        if (this.configurator.isStale()) {
            ControlFlowConfigurator controlFlowConfigurator = this.configurator;
            synchronized (controlFlowConfigurator) {
                if (this.configurator.isStale()) {
                    this.reloadConfiguration();
                }
            }
        }
    }

    void reloadConfiguration() {
        try {
            ArrayList<FlowController> newControllers = new ArrayList<FlowController>(this.configurator.buildFlowControllers());
            Collections.sort(newControllers, new ControllerPriorityComparator());
            this.controllers = newControllers;
            int controllersCount = this.controllers.size();
            if (controllersCount > 0) {
                LOGGER.config("Control-flow active with " + controllersCount + " flow controllers");
            } else {
                LOGGER.config("Control-flow inactive, there are no configured rules");
            }
            this.timeout = this.configurator.getTimeout();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurerd during flow controllers reconfiguration");
        }
    }
}

