/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.flow.ControlFlowConfigurator;
import org.geoserver.flow.DefaultFlowControllerProvider;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.FlowControllerProvider;
import org.geoserver.flow.config.DefaultControlFlowConfigurator;
import org.geoserver.flow.controller.SingleQueueFlowController;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ControlFlowCallback
extends AbstractDispatcherCallback
implements ApplicationContextAware,
GeoServerFilter {
    static final String X_RATELIMIT_DELAY = "X-Control-flow-delay-ms";
    public static final String X_CONCURRENT_LIMIT = "X-Concurrent-Limit";
    public static final String X_CONCURRENT_REQUESTS = "X-Concurrent-Requests";
    static final Logger LOGGER = Logging.getLogger(ControlFlowCallback.class);
    static ThreadLocal<CallbackContext> REQUEST_CONTROLLERS = new ThreadLocal();
    static ThreadLocal<Boolean> FAILED_ON_FLOW_CONTROLLERS = new ThreadLocal();
    FlowControllerProvider provider;
    AtomicLong blockedRequests = new AtomicLong();
    AtomicLong runningRequests = new AtomicLong();

    public ControlFlowCallback() {
        REQUEST_CONTROLLERS.remove();
    }

    public long getBlockedRequests() {
        return this.blockedRequests.get();
    }

    public long getRunningRequests() {
        return this.runningRequests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation operationDispatched(Request request, Operation operation) {
        if (REQUEST_CONTROLLERS.get() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Nested request found, not locking on it");
            }
            ++ControlFlowCallback.REQUEST_CONTROLLERS.get().nestingLevel;
            return operation;
        }
        this.blockedRequests.incrementAndGet();
        long start = System.currentTimeMillis();
        boolean failedOnFlowControllers = true;
        try {
            Request requestWithOperation = null;
            if (request != null) {
                requestWithOperation = new Request(request);
                requestWithOperation.setOperation(operation);
            }
            List<FlowController> controllers = null;
            try {
                controllers = this.provider.getFlowControllers(requestWithOperation);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An error occurred setting up the flow controllers to this request", e);
                Operation operation2 = operation;
                this.blockedRequests.decrementAndGet();
                if (!failedOnFlowControllers) {
                    this.runningRequests.incrementAndGet();
                }
                FAILED_ON_FLOW_CONTROLLERS.set(failedOnFlowControllers);
                if (REQUEST_CONTROLLERS.get() != null && LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Request control-flow performed, running requests: " + this.getRunningRequests() + ", blocked requests: " + this.getBlockedRequests());
                }
                if (request != null && request.getHttpResponse() != null) {
                    long end = System.currentTimeMillis();
                    request.getHttpResponse().addHeader(X_RATELIMIT_DELAY, String.valueOf(end - start));
                }
                return operation2;
            }
            if (controllers.isEmpty()) {
                LOGGER.config("Control-flow inactive, there are no configured rules");
            } else {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Request [" + requestWithOperation + "] starting, processing through flow controllers");
                }
                long timeout = this.provider.getTimeout(requestWithOperation);
                CallbackContext context = new CallbackContext(requestWithOperation, controllers, timeout);
                REQUEST_CONTROLLERS.set(context);
                long maxTime = timeout > 0L ? System.currentTimeMillis() + timeout : -1L;
                for (FlowController controller : controllers) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(ControlFlowCallback.getControllerEnterMessage(controller, requestWithOperation));
                    }
                    if (timeout > 0L) {
                        long maxWait = maxTime - System.currentTimeMillis();
                        if (!controller.requestIncoming(requestWithOperation, maxWait)) {
                            throw new HttpErrorCodeException(503, "Requested timeout out while waiting to be executed, please lower your request rate");
                        }
                    } else {
                        controller.requestIncoming(requestWithOperation, -1L);
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(ControlFlowCallback.getControllerExitMessage(controller, requestWithOperation));
                }
            }
            failedOnFlowControllers = false;
        }
        finally {
            this.blockedRequests.decrementAndGet();
            if (!failedOnFlowControllers) {
                this.runningRequests.incrementAndGet();
            }
            FAILED_ON_FLOW_CONTROLLERS.set(failedOnFlowControllers);
            if (REQUEST_CONTROLLERS.get() != null && LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Request control-flow performed, running requests: " + this.getRunningRequests() + ", blocked requests: " + this.getBlockedRequests());
            }
            if (request != null && request.getHttpResponse() != null) {
                long end = System.currentTimeMillis();
                request.getHttpResponse().addHeader(X_RATELIMIT_DELAY, String.valueOf(end - start));
            }
        }
        return operation;
    }

    private static String getControllerEnterMessage(FlowController controller, Request requestWithOperation) {
        String message = "Request [" + requestWithOperation + "] enter " + controller;
        if (controller instanceof SingleQueueFlowController) {
            int requests = ((SingleQueueFlowController)controller).getRequestsInQueue();
            message = message + "/" + requests;
        }
        return message;
    }

    private static String getControllerExitMessage(FlowController controller, Request requestWithOperation) {
        String message = "Request [" + requestWithOperation + "] exit  " + controller;
        if (controller instanceof SingleQueueFlowController) {
            int requests = ((SingleQueueFlowController)controller).getRequestsInQueue();
            message = message + "/" + requests;
        }
        return message;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.registDefaultBeansIfNeeded((ConfigurableApplicationContext)applicationContext);
        } else {
            LOGGER.warning("Application context not configurable, control-flow default beans will not be registered.");
        }
        this.provider = (FlowControllerProvider)GeoServerExtensions.bean(FlowControllerProvider.class, (ApplicationContext)applicationContext);
        if (this.provider == null) {
            this.provider = new DefaultFlowControllerProvider(applicationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registDefaultBeansIfNeeded(ConfigurableApplicationContext applicationContext) {
        ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
        Class<ControlFlowCallback> clazz = ControlFlowCallback.class;
        synchronized (ControlFlowCallback.class) {
            try {
                applicationContext.getBean(ControlFlowConfigurator.class, new Object[]{applicationContext});
            }
            catch (NoSuchBeanDefinitionException exception) {
                factory.registerSingleton("defaultControlFlowConfigurator", (Object)new DefaultControlFlowConfigurator());
                LOGGER.fine("Default flow configurator bean dynamically registered.");
            }
            try {
                applicationContext.getBean(FlowControllerProvider.class, new Object[]{applicationContext});
            }
            catch (NoSuchBeanDefinitionException exception) {
                factory.registerSingleton("defaultFlowControllerProvider", (Object)new DefaultFlowControllerProvider((ApplicationContext)applicationContext));
                LOGGER.fine("Default flow controller provider bean dynamically registered.");
            }
            return;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void finished(Request request) {
        this.releaseControllers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.releaseControllers(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseControllers(boolean forceRelease) {
        CallbackContext context = REQUEST_CONTROLLERS.get();
        try {
            if (context != null) {
                --context.nestingLevel;
                if (context.nestingLevel <= 0 || forceRelease) {
                    if (Boolean.FALSE.equals(FAILED_ON_FLOW_CONTROLLERS.get())) {
                        this.runningRequests.decrementAndGet();
                    }
                    LOGGER.info("releasing flow controllers for [" + context.request + "]");
                    List<FlowController> controllers = context.controllers;
                    for (int i = controllers.size() - 1; i >= 0; --i) {
                        FlowController flowController = controllers.get(i);
                        try {
                            flowController.requestComplete(context.request);
                            continue;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.SEVERE, "Flow controller " + flowController + " failed to mark the request as complete", t);
                        }
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Request completed, running requests: " + this.getRunningRequests() + ", blocked requests: " + this.getBlockedRequests());
                    }
                }
            }
        }
        finally {
            if (context != null && (context.nestingLevel <= 0 || forceRelease)) {
                REQUEST_CONTROLLERS.remove();
            }
        }
    }

    public void destroy() {
    }

    static final class CallbackContext {
        List<FlowController> controllers;
        long timeout;
        Request request;
        int nestingLevel = 1;

        public CallbackContext(Request request, List<FlowController> controllers, long timeout) {
            this.controllers = controllers;
            this.timeout = timeout;
            this.request = request;
        }
    }
}

