/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.flow.ControlFlowCallback;
import org.geoserver.flow.controller.CookieKeyGenerator;
import org.geoserver.flow.controller.QueueController;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class UserConcurrentFlowController
extends QueueController {
    static final Logger LOGGER = Logging.getLogger(ControlFlowCallback.class);
    static ThreadLocal<String> QUEUE_ID = new ThreadLocal();
    CookieKeyGenerator keyGenerator = new CookieKeyGenerator();

    public UserConcurrentFlowController(int queueSize) {
        this(queueSize, 100, 10000);
    }

    public UserConcurrentFlowController(int queueSize, int maxQueues, int maxAge) {
        this.queueMaxSize = queueSize;
        this.maxQueues = maxQueues;
        this.maxAge = maxAge;
    }

    @Override
    public void requestComplete(Request request) {
        BlockingQueue queue;
        String queueId = QUEUE_ID.get();
        QUEUE_ID.remove();
        if (queueId != null && (queue = (BlockingQueue)this.queues.get(queueId)) != null) {
            queue.remove(request);
        }
    }

    @Override
    public boolean requestIncoming(Request request, long timeout) {
        boolean retval = true;
        long now = System.currentTimeMillis();
        String queueId = this.keyGenerator.getUserKey(request);
        QUEUE_ID.set(queueId);
        QueueController.TimedBlockingQueue queue = (QueueController.TimedBlockingQueue)this.queues.get(queueId);
        if (queue == null) {
            queue = new QueueController.TimedBlockingQueue(this.queueMaxSize, true);
            this.queues.put(queueId, queue);
        }
        try {
            if (timeout > 0L) {
                retval = queue.offer(request, timeout, TimeUnit.MILLISECONDS);
            } else {
                queue.put(request);
            }
            request.getHttpResponse().addHeader("X-Concurrent-Limit-user", String.valueOf(this.queueMaxSize));
            request.getHttpResponse().addHeader("X-Concurrent-Requests-user", String.valueOf(queue.size()));
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Unexpected interruption while blocking on the request queue");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UserFlowController(" + this.queueMaxSize + "," + queueId + ") queue size " + queue.size());
        }
        this.cleanUpQueues(now);
        return retval;
    }

    public String toString() {
        return "UserConcurrentFlowController{queueMaxSize=" + this.queueMaxSize + "}";
    }
}

