/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.flow.controller.QueueController;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;

public class IpFlowController
extends QueueController {
    static ThreadLocal<String> QUEUE_ID = new ThreadLocal();
    static final Logger LOGGER = Logging.getLogger(IpFlowController.class);

    public IpFlowController(int queueSize) {
        this.queueMaxSize = queueSize;
    }

    @Override
    public void requestComplete(Request request) {
        QueueController.TimedBlockingQueue queue;
        String queueId = QUEUE_ID.get();
        QUEUE_ID.remove();
        if (queueId != null && (queue = (QueueController.TimedBlockingQueue)this.queues.get(queueId)) != null) {
            queue.remove(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestIncoming(Request request, long timeout) {
        boolean retval = true;
        long now = System.currentTimeMillis();
        String ip = IpFlowController.getRemoteAddr(request.getHttpRequest());
        String incomingIp = null == ip || "".equals(ip) ? "" : ip;
        QueueController.TimedBlockingQueue queue = (QueueController.TimedBlockingQueue)this.queues.get(incomingIp);
        if (queue == null) {
            IpFlowController ipFlowController = this;
            synchronized (ipFlowController) {
                queue = (QueueController.TimedBlockingQueue)this.queues.get(incomingIp);
                if (queue == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("IpFlowController(" + this.queueMaxSize + ")," + incomingIp + ", creating new queue");
                    }
                    queue = new QueueController.TimedBlockingQueue(this.queueMaxSize, true);
                    this.queues.put(incomingIp, queue);
                }
            }
        }
        QUEUE_ID.set(incomingIp);
        try {
            if (timeout > 0L) {
                retval = queue.offer(request, timeout, TimeUnit.MILLISECONDS);
            } else {
                queue.put(request);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("IpFlowController(" + this.queueMaxSize + ") " + incomingIp + ", concurrent requests: " + queue.size());
            }
            request.getHttpResponse().addHeader("X-Concurrent-Limit-ip", String.valueOf(this.queueMaxSize));
            request.getHttpResponse().addHeader("X-Concurrent-Requests-ip", String.valueOf(queue.size()));
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Unexpected interruption while blocking on the request queue");
        }
        this.cleanUpQueues(now);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("IpFlowController(" + this.queueMaxSize + "," + incomingIp + ") queue size " + queue.size());
        }
        return retval;
    }

    static String getRemoteAddr(HttpServletRequest req) {
        String ip;
        String forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            if (-1 == forwardedFor.indexOf(44)) {
                return forwardedFor;
            }
            String[] ips = forwardedFor.split(", ");
            ip = ips[0];
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("X-Forwarded-For: " + forwardedFor + " -> " + ip);
            }
        } else {
            ip = req.getRemoteAddr();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("X-Forwarded-For missing, ip from servlet request " + ip);
            }
        }
        return ip;
    }

    public String toString() {
        return "IpFlowController(" + this.queueMaxSize + ")";
    }
}

