/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.setup;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.test.onlineTest.setup.ReferenceDataGeopackageSetup;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Geometry;

public class AppSchemaTestGeopackageSetup
extends ReferenceDataGeopackageSetup {
    private List<Integer> sridList = Arrays.asList(4326, -1, 0);
    public static String DB_PARAMS = "<parameters>\n<Parameter>\n<name>dbtype</name>\n<value>geopkg</value>\n</Parameter>\n<Parameter>\n<name>database</name>\n<value>PATH_TO_BE_REPLACED</value>\n</Parameter>\n<Parameter>\n<name>Expose primary keys</name>\n<value>true</value>\n</Parameter></parameters>";
    private String sql;

    public static AppSchemaTestGeopackageSetup getInstance(Map<String, File> propertyFiles, String geopkgDir) throws Exception {
        return new AppSchemaTestGeopackageSetup(propertyFiles, geopkgDir);
    }

    public AppSchemaTestGeopackageSetup(Map<String, File> propertyFiles, String geopkgDir) throws Exception {
        this.geopkgDir = geopkgDir;
        this.configureFixture();
        this.createTables(propertyFiles);
    }

    private void createTables(Map<String, File> propertyFiles) throws IllegalAttributeException, NoSuchElementException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("DELETE FROM gpkg_spatial_ref_sys where srs_id not in (4326, -1, 0);\n");
        for (String fileName : propertyFiles.keySet()) {
            List<Object> geoms = new ArrayList<GeometryDescriptor>();
            File file = new File(propertyFiles.get(fileName), fileName);
            try (PropertyFeatureReader reader = new PropertyFeatureReader("test", file);){
                SimpleFeatureType schema = reader.getFeatureType();
                String tableName = schema.getName().getLocalPart().toUpperCase();
                this.removeGeometryColumnsFromTable(tableName, buf);
                buf.append("DROP TABLE IF EXISTS ").append(tableName).append(";\n");
                buf.append("CREATE TABLE ").append(tableName).append(" (");
                int size = schema.getAttributeCount() + 1;
                Object[] fieldNames = new String[size];
                ArrayList<CallSite> createParams = new ArrayList<CallSite>();
                int j = 0;
                for (PropertyDescriptor desc : schema.getDescriptors()) {
                    if (desc instanceof GeometryDescriptor) {
                        geoms.add((GeometryDescriptor)desc);
                    } else {
                        String field = "\"" + desc.getName() + "\" ";
                        String type = Classes.getShortName((Class)desc.getType().getBinding());
                        if (type.equalsIgnoreCase("String")) {
                            type = "TEXT";
                        } else if (type.equalsIgnoreCase("Double")) {
                            type = "DOUBLE PRECISION";
                        }
                        field = field + type;
                        createParams.add((CallSite)((Object)field));
                    }
                    fieldNames[j] = desc.getName().toString();
                    ++j;
                }
                String pkFieldName = schema.getTypeName() + "_PKEY";
                fieldNames[j] = pkFieldName;
                createParams.add((CallSite)((Object)("\"" + pkFieldName + "\" TEXT")));
                buf.append(StringUtils.join(createParams.iterator(), (String)", "));
                buf.append(", PRIMARY KEY (").append(pkFieldName).append("));\n");
                geoms = geoms.stream().distinct().collect(Collectors.toList());
                int count = 0;
                for (GeometryDescriptor geometryDescriptor : geoms) {
                    String geomColumnName = geometryDescriptor.getName().toString();
                    buf.append("ALTER TABLE " + tableName + " add \"" + geomColumnName + "\" GEOMETRY;\n");
                    if (count != 0) continue;
                    this.addGeometryColumnsToTable(tableName, buf, geomColumnName, geometryDescriptor);
                    ++count;
                }
                if (geoms.isEmpty()) {
                    buf.append("INSERT INTO gpkg_contents (table_name, data_type, identifier, srs_id) VALUES ('" + tableName + "', 'features', '" + tableName + "', 4326);\n");
                }
                while (reader.hasNext()) {
                    buf.append("INSERT INTO ").append(tableName).append(" (\"");
                    SimpleFeature feature = reader.next();
                    this.moveGeometryColumnInFieldNames(geoms, (String[])fieldNames);
                    buf.append(StringUtils.join((Object[])fieldNames, (String)"\", \""));
                    buf.append("\") ");
                    buf.append("VALUES (");
                    Collection properties = feature.getProperties();
                    Object[] values = new String[size];
                    int valueIndex = 0;
                    for (Property prop : properties) {
                        Object value = prop.getValue();
                        if (value instanceof Geometry) {
                            Geometry geom = (Geometry)value;
                            String s = this.toString(geom);
                            String geomValue = "GEOM_INDEXX'" + s + "'";
                            values[valueIndex] = geomValue;
                            value = geomValue;
                        }
                        values[valueIndex] = value == null || value.toString().equalsIgnoreCase("null") ? "null" : "'" + value + "'";
                        ++valueIndex;
                    }
                    FeatureId featureId = feature.getIdentifier();
                    values[valueIndex] = "'" + featureId.toString() + "'";
                    this.moveGeometryValueInValues((String[])values);
                    buf.append(StringUtils.join((Object[])values, (String)","));
                    buf.append(");\n");
                }
            }
            if (buf.length() <= 0) continue;
            this.sql = buf.toString();
        }
    }

    private void moveGeometryColumnInFieldNames(List<GeometryDescriptor> geoms, String[] fieldNames) {
        ArrayList<String> fieldNamesList = new ArrayList<String>(Arrays.asList(fieldNames));
        String geometryName = "";
        if (geoms.size() > 1) {
            for (String fieldName : fieldNamesList) {
                for (GeometryDescriptor geom : geoms) {
                    if (!geom.getName().toString().equals(fieldName)) continue;
                    geometryName = fieldName;
                }
            }
        } else if (geoms.size() == 1) {
            geometryName = geoms.get(0).getName().toString();
        }
        if (fieldNamesList.contains(geometryName)) {
            int geomIndex = fieldNamesList.indexOf(geometryName);
            String temp = fieldNames[geomIndex];
            fieldNames[geomIndex] = fieldNames[fieldNames.length - 1];
            fieldNames[fieldNames.length - 1] = temp;
        }
    }

    private void moveGeometryValueInValues(String[] values) {
        Optional<String> optGeomString = Arrays.stream(values).filter(value -> value.startsWith("'GEOM_INDEX")).findFirst();
        if (optGeomString.isPresent()) {
            String geomString = optGeomString.get();
            ArrayList<String> valuesList = new ArrayList<String>(Arrays.asList(values));
            int index = valuesList.indexOf(geomString);
            String temp = values[index].substring(11, values[index].length() - 1);
            values[index] = values[values.length - 1];
            values[values.length - 1] = temp;
        }
    }

    @Override
    protected void runSqlInsertScript() throws Exception {
        this.run(this.sql, false);
    }

    String toString(Geometry g) throws IOException {
        byte[] bytes = new GeoPkgGeomWriter().write(g);
        return AppSchemaTestGeopackageSetup.toHexString(bytes);
    }

    public static String toHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private void removeGeometryColumnsFromTable(String tableName, StringBuffer buf) {
        buf.append("DELETE FROM gpkg_contents where table_name ='" + tableName + "';\n");
        buf.append("DELETE FROM gpkg_extensions where table_name ='" + tableName + "';\n");
        buf.append("DELETE FROM gpkg_geometry_columns where table_name ='" + tableName + "';\n");
    }

    private void addGeometryColumnsToTable(String tableName, StringBuffer buf, String columnName, GeometryDescriptor geom) {
        int srid = this.getSrid(geom.getType());
        buf.append("INSERT INTO gpkg_contents (table_name, data_type, identifier, srs_id) VALUES ('" + tableName + "', 'features', '" + tableName + "', " + srid + ");\n");
        buf.append("INSERT INTO gpkg_geometry_columns VALUES ('" + tableName + "', '" + columnName + "', 'GEOMETRY', " + srid + " , 2, 0);\n");
        buf.append("INSERT INTO gpkg_extensions VALUES('" + tableName + "', '" + columnName + "', 'gpkg_rtree_index', 'http://www.geopackage.org/spec120/#extension_rtree', 'write-only');\n");
        if (!this.sridList.contains(srid)) {
            buf.append("INSERT INTO gpkg_spatial_ref_sys VALUES('" + tableName + "', '" + srid + "', 'EPSG', '" + srid + "', '" + tableName + "', '" + tableName + "' );\n");
        }
    }
}

