/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import org.geoserver.config.ServiceInfo;
import org.geoserver.test.onlineTest.support.AbstractDataReferenceWfsTest;
import org.geoserver.wfs.WFSInfo;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.Types;
import org.geotools.filter.LikeFilterImpl;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public abstract class DataReferenceWfsOnlineTest
extends AbstractDataReferenceWfsTest {
    private boolean printDoc = false;
    protected static final String OM_URI = "http://www.opengis.net/om/1.0";
    protected static final String OM_SCHEMA_LOCATION_URL = "http://schemas.opengis.net/om/1.0.0/observation.xsd";

    @Test
    public void testGetCapabilities() {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities&version=1.1.0");
        if (this.printDoc) {
            LOGGER.info("WFS =GetCapabilities response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(6, "//wfs:FeatureType", doc);
        ArrayList<String> featureTypeNames = new ArrayList<String>(7);
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[1]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[2]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[3]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[4]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[5]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[6]/wfs:Name", doc));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:Contact"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:DisplacementEvent"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:GeologicEvent"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:GeologicUnit"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:MappedFeature"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:ShearDisplacementStructure"));
    }

    @Test
    public void testDescribeFeatureType() throws IOException {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:MappedFeature");
        if (this.printDoc) {
            LOGGER.info("WFS DescribeFeatureType, typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:GeologicUnit");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:Contact");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:Contact response:\n" + this.prettyString(doc));
        this.testConsistantSchema(doc);
        doc = null;
        System.gc();
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:Contact,gsml:MappedFeature");
        if (this.printDoc) {
            LOGGER.info("WFS DescribeFeatureType, typename=gsml:Contact,gsml:MappedFeature response:\n" + this.prettyString(doc));
        }
        this.testConsistantSchema(doc);
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0");
        LOGGER.info("WFS DescribeFeatureType, typename=none response:\n" + this.prettyString(doc));
    }

    private void testConsistantSchema(Document doc) {
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(1, "//xsd:import", doc);
        this.assertXpathEvaluatesTo(OM_URI, "//xsd:import/@namespace", doc);
        this.assertXpathEvaluatesTo(OM_SCHEMA_LOCATION_URL, "//xsd:import/@schemaLocation", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testMapping() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126932776,gsml.geologicunit.167775491110573732,gsml.geologicunit.16777549126930540";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        }
        this.checkSchemaLocation(doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191322']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191322']/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191922']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191922']/gsml:samplingFrame/@xlink:href", doc);
        this.checkGU167775491110573732(doc);
        this.checkGU16777549126930540(doc);
        this.checkGU16777549126932776(doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typename=gsml:ConstituentPart");
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:ConstituentPart response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    private void checkGU167775491110573732(Document doc) {
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Lithodemic_IntrusiveUnitRank", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:rank/@codeSpace", doc);
        this.assertXpathEvaluatesTo("Intrusion [rank]", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:rank", doc);
    }

    private void checkGU16777549126932776(Document doc) {
        ArrayList<String> name = new ArrayList<String>();
        name.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gml:name[1]", doc));
        name.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gml:name[2]", doc));
        Assert.assertTrue((boolean)name.contains("Castlemaine Group (Oc)"));
        Assert.assertTrue((boolean)name.contains("urn:cgi:feature:GSV:GeologicUnit:16777549126932776"));
        ArrayList<String> nameCodespace = new ArrayList<String>();
        nameCodespace.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gml:name[1]/@codeSpace", doc));
        nameCodespace.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gml:name[2]/@codeSpace", doc));
        Assert.assertTrue((boolean)nameCodespace.contains("http://www.dpi.vic.gov.au/earth-resources"));
        Assert.assertTrue((boolean)nameCodespace.contains("http://www.ietf.org/rfc/rfc2141"));
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("#gsml.geologicevent.16777549126932777", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:preferredAge/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:MiddleOrdovician", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Cambrian", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        ArrayList<String> eventEnvironment = new ArrayList<String>();
        eventEnvironment.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventEnvironment[1]/gsml:CGI_TermValue/gsml:value", doc));
        eventEnvironment.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventEnvironment[2]/gsml:CGI_TermValue/gsml:value", doc));
        Assert.assertTrue((boolean)eventEnvironment.contains("hemipelagic"));
        Assert.assertTrue((boolean)eventEnvironment.contains("submarine fan"));
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:MarineEnvironments", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventEnvironment[1]/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        ArrayList<String> eventProcess = new ArrayList<String>();
        eventProcess.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventProcess[1]/gsml:CGI_TermValue/gsml:value", doc));
        eventProcess.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126932777']/gsml:eventProcess[2]/gsml:CGI_TermValue/gsml:value", doc));
        Assert.assertTrue((boolean)eventProcess.contains("water [process]"));
        Assert.assertTrue((boolean)eventProcess.contains("turbidity current"));
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:GeologicUnitType:200811:lithostratigraphic_unit", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathEvaluatesTo("Group [lithostratigraphic]", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:rank", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110575003']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("indurated", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110575003']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:ConsolidationDegree", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110575003']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:sandstone", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110575003']/gsml:lithology/@xlink:href", doc);
        this.assertXpathEvaluatesTo("unit part", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:part/gsml:GeologicUnitPart/gsml:role", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Provisional:GeologicalUnitPart", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:part/gsml:GeologicUnitPart/gsml:role/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:part/gsml:GeologicUnitPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:part/gsml:GeologicUnitPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("http://urn.resolver.url/?uri=urn:cgi:feature:GSV:GeologicUnit:16777549126932767", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:part/gsml:GeologicUnitPart/gsml:containedUnit/@xlink:href", doc);
        this.assertXpathEvaluatesTo("2.114", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:g.cm-3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("2.955", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:g.cm-3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("0.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM::SI", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("2700.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM::SI", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    private void checkGU16777549126930540(Document doc) {
        ArrayList<String> name = new ArrayList<String>();
        name.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gml:name[1]", doc));
        name.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gml:name[2]", doc));
        Assert.assertTrue((boolean)name.contains("urn:cgi:feature:GSV:GeologicUnit:16777549126930540"));
        Assert.assertTrue((boolean)name.contains("Unnamed incised alluvium (Na)"));
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("previous mapping", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:InterpretationMethod", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:GSV:GeologicUnit:16777549126930540", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.195237']/gsml:specification/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#gsml.geologicevent.16777549126930541", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:preferredAge/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Pleistocene", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Miocene", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("fluvial", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventEnvironment/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:TerrestrialEnvironments", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventEnvironment/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("channelled stream flow", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventProcess/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Process", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventProcess/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110573565']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("consolidated", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110573565']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:ConsolidationDegree", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110573565']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:gravel", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491110573565']/gsml:lithology/@xlink:href", doc);
    }

    private void checkSchemaLocation(Document doc) {
        String schemaLocation = this.evaluate("/wfs:FeatureCollection/@xsi:schemaLocation", doc);
        String gsmlLocation = "urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd";
        String wfsLocation = "http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd";
        if (schemaLocation.startsWith("urn:cgi:xmlns:CGI:GeoSciML:2.0")) {
            Assert.assertEquals((Object)(gsmlLocation + " " + wfsLocation), (Object)schemaLocation);
        } else {
            Assert.assertEquals((Object)(wfsLocation + " " + gsmlLocation), (Object)schemaLocation);
        }
    }

    @Test
    public void testEncodeFeatureMember() {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        boolean encodeFeatureMember = wfs.isEncodeFeatureMember();
        wfs.setEncodeFeatureMember(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126932776,gsml.geologicunit.167775491110573732,gsml.geologicunit.16777549126930540";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        }
        this.checkSchemaLocation(doc);
        this.assertXpathEvaluatesTo("3", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        Assert.assertEquals((long)0L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("gml:featureMembers").getLength());
        this.checkGU167775491110573732(doc);
        this.checkGU16777549126930540(doc);
        this.checkGU16777549126932776(doc);
        wfs.setEncodeFeatureMember(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126932776,gsml.geologicunit.167775491110573732,gsml.geologicunit.16777549126930540";
        doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        }
        this.checkSchemaLocation(doc);
        this.assertXpathEvaluatesTo("3", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        Assert.assertEquals((long)3L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)0L, (long)doc.getElementsByTagName("gml:featureMembers").getLength());
        this.checkGU167775491110573732(doc);
        this.checkGU16777549126930540(doc);
        this.checkGU16777549126932776(doc);
        wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEncodeFeatureMember(encodeFeatureMember);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testMinOccur0() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:ShearDisplacementStructure&featureid=gsml.sheardisplacementstructure.46220,gsml.sheardisplacementstructure.46216";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:ShearDisplacementStructure response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("E", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46216']/gsml:geologicHistory/gsml:DisplacementEvent/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46220']/gsml:geologicHistory/gsml:DisplacementEvent/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:NullValues", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46220']/gsml:geologicHistory/gsml:DisplacementEvent/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementSense/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
    }

    @Test
    public void testReprojection() {
        String path = "wfs?request=GetFeature&version=1.1.0&srsName=urn:x-ogc:def:crs:EPSG:4283&typename=gsml:MappedFeature&featureid=gsml.mappedfeature.191922";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//gsml:MappedFeature/gsml:shape/gml:MultiSurface/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature/gsml:shape/gml:MultiSurface/@srsDimension", doc);
        String expected = "-37.391436383333335 144.782547975 -37.39050545 144.78374375833334 -37.38964884166667 144.78460036666667 -37.388678025 144.78522854166667 -37.38776430833333 144.78597093333335 -37.386736383333336 144.7864849 -37.38399524166667 144.788712075 -37.38199649166667 144.79002553333333 -37.38108278333333 144.790767925 -37.3787685 144.7914741 -37.37675986666667 144.79356964166666 -37.377616466666666 144.79436913333333 -37.378701508333336 144.79396939166668 -37.37972944166667 144.79339831666667 -37.380871575 144.79316989166668 -37.38201371666667 144.79311279166666 -37.38315585833333 144.79282725 -37.386011208333336 144.79088560833333 -37.387781525 144.78934370833332 -37.389951591666666 144.78843 -37.39092241666667 144.787801825 -37.39172191666667 144.78694521666668 -37.392178775 144.78586018333334 -37.392235875 144.78471804166668 -37.39172191666667 144.78369011666666 -37.391436383333335 144.782547975";
        String orig = this.evaluate("//gsml:MappedFeature/gsml:shape/gml:MultiSurface/gml:surfaceMember/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(orig, expected, 5));
        path = "wfs?request=GetFeature&version=1.1.0&srsName=EPSG:4283&typename=gsml:MappedFeature&featureid=gsml.mappedfeature.191922";
        doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature/gsml:shape/gml:MultiSurface/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature/gsml:shape/gml:MultiSurface/@srsDimension", doc);
        expected = "144.782547975 -37.391436383333335 144.78374375833334 -37.39050545 144.78460036666667 -37.38964884166667 144.78522854166667 -37.388678025 144.78597093333335 -37.38776430833333 144.7864849 -37.386736383333336 144.788712075 -37.38399524166667 144.79002553333333 -37.38199649166667 144.790767925 -37.38108278333333 144.7914741 -37.3787685 144.79356964166666 -37.37675986666667 144.79436913333333 -37.377616466666666 144.79396939166668 -37.378701508333336 144.79339831666667 -37.37972944166667 144.79316989166668 -37.380871575 144.79311279166666 -37.38201371666667 144.79282725 -37.38315585833333 144.79088560833333 -37.386011208333336 144.78934370833332 -37.387781525 144.78843 -37.389951591666666 144.787801825 -37.39092241666667 144.78694521666668 -37.39172191666667 144.78586018333334 -37.392178775 144.78471804166668 -37.392235875 144.78369011666666 -37.39172191666667 144.782547975 -37.391436383333335";
        orig = this.evaluate("//gsml:MappedFeature/gsml:shape/gml:MultiSurface/gml:surfaceMember/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(orig, expected, 5));
    }

    private boolean isEqualGeometry(String orig, String expected, int leniency) {
        String[] expCoordinates;
        String[] origCoordinates = orig.split(" ");
        if (origCoordinates.length != (expCoordinates = expected.split(" ")).length) {
            return false;
        }
        for (int i = 0; i < origCoordinates.length; ++i) {
            BigDecimal origBd = new BigDecimal(origCoordinates[i]);
            BigDecimal expBd = new BigDecimal(expCoordinates[i]);
            if ((origBd = origBd.setScale(leniency, RoundingMode.HALF_UP)).equals(expBd = expBd.setScale(leniency, RoundingMode.HALF_UP))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testValidate() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126932776,gsml.geologicunit.167775491110573732,gsml.geologicunit.16777549126930540";
        this.validateGet(path);
    }

    @Test
    public void testGetFeatureWithFeatureIdFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:FeatureId fid=\"gsml.geologicunit.16777549126932776\"/>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.checkGU16777549126932776(doc);
    }

    @Test
    public void testGetFeatureWithGmlObjectIdFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:GmlObjectId gml:id=\"gsml.geologicunit.16777549126932776\"/>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.checkGU16777549126932776(doc);
    }

    @Test
    public void testFilteringNestedMultiValuedAttribute() {
        int i;
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:Literal>Akuna Mudstone (Oba)</ogc:Literal>                <ogc:PropertyName>gml:name</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gsml.geologicunit.167775491107848330", "//gsml:GeologicUnit/@gml:id", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>*Creek Granite*</ogc:Literal>            </ogc:PropertyIsLike>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("9", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(9, "//gsml:GeologicUnit", doc);
        ArrayList<String> ids = new ArrayList<String>();
        for (i = 1; i <= 9; ++i) {
            ids.add(this.evaluate("(//gsml:GeologicUnit)[" + i + "]/@gml:id", doc));
        }
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513315832"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513318069"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513318192"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126941084"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126941436"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942189"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942227"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942588"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942855"));
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\"><wfs:Query typeName=\"gsml:GeologicUnit\">    <ogc:Filter>        <ogc:And>            <ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">>                <ogc:Literal>*Creek Granite*</ogc:Literal>                <ogc:PropertyName>gml:name</ogc:PropertyName>            </ogc:PropertyIsLike>                <ogc:Not>                    <ogc:PropertyIsEqualTo>                        <ogc:Literal>mid-crustal</ogc:Literal>                        <ogc:PropertyName>gsml:geologicHistory/gsml:GeologicEvent/gsml:eventEnvironment/gsml:CGI_TermValue/gsml:value</ogc:PropertyName>                    </ogc:PropertyIsEqualTo>                </ogc:Not>        </ogc:And>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("6", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(6, "//gsml:GeologicUnit", doc);
        ids.clear();
        for (i = 1; i <= 6; ++i) {
            ids.add(this.evaluate("(//gsml:GeologicUnit)[" + i + "]/@gml:id", doc));
        }
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513318069"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513318192"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126941436"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942189"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942227"));
        Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942855"));
    }

    @Test
    public void testGetFeaturePropertyFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>Unnamed incised alluvium (Na)</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.checkGU16777549126930540(doc);
    }

    @Test
    public void testFilterOnNestedAttribute() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value</ogc:PropertyName>                <ogc:Literal>significant</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathCount(6, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107848330']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']", doc);
        this.assertXpathEvaluatesTo("significant", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Proportion", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.checkGU16777549126930540(doc);
        this.checkGU16777549126932776(doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace</ogc:PropertyName>                <ogc:Literal>urn:cgi:classifierScheme:GSV:Proportion</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathCount(17, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838594']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838781']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838810']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107848330']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513315832']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Proportion", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513315832']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("all", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513315832']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
    }

    @Test
    public void testFilterOnPolymorphicFeatures() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\"><wfs:Query typeName=\"gsml:GeologicUnit\">    <ogc:Filter>        <ogc:Or>            <ogc:PropertyIsEqualTo>                <ogc:Literal>900.0</ogc:Literal>                <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue</ogc:PropertyName>            </ogc:PropertyIsEqualTo>            <ogc:PropertyIsEqualTo>                 <ogc:Literal>urn:ogc:def:uom:UCUM::SI</ogc:Literal>                 <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Or>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("900.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM::SI", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("2700.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
    }

    @Test
    public void testResultHitsWithFilter() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:Contact&resultType=hits";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info(this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("5", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" resultType=\"hits\" maxFeatures=\"1\"><wfs:Query typeName=\"gsml:GeologicUnit\">    <ogc:Filter>        <ogc:Or>            <ogc:PropertyIsEqualTo>                <ogc:Literal>900.0</ogc:Literal>                <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue</ogc:PropertyName>            </ogc:PropertyIsEqualTo>            <ogc:PropertyIsEqualTo>                 <ogc:Literal>urn:ogc:def:uom:UCUM::SI</ogc:Literal>                 <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Or>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" resultType=\"hits\"><wfs:Query typeName=\"gsml:GeologicUnit\">    <ogc:Filter>        <ogc:Or>            <ogc:PropertyIsEqualTo>                <ogc:Literal>900.0</ogc:Literal>                <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue</ogc:PropertyName>            </ogc:PropertyIsEqualTo>            <ogc:PropertyIsEqualTo>                 <ogc:Literal>urn:ogc:def:uom:UCUM::SI</ogc:Literal>                 <ogc:PropertyName>gsml:GeologicUnit/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue/@uom</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Or>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        if (this.printDoc) {
            LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("5", "/wfs:FeatureCollection/@numberOfFeatures", doc);
    }

    @Test
    public void testGeologicUnit() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126930540,gsml.geologicunit.167775491107838881,gsml.geologicunit.16777549126931275,gsml.geologicunit.167775491233249211,gsml.geologicunit.1677754911513318041,gsml.geologicunit.167775491107843155,gsml.geologicunit.16777549126932958,gsml.geologicunit.16777549126932676,gsml.geologicunit.16777549126932776,gsml.geologicunit.167775491110573732,gsml.geologicunit.1677754911513320744";
        this.validateGet(path);
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info(this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("11", "//wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Pleistocene", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Miocene", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("fluvial", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventEnvironment/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("channelled stream flow", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory/gsml:GeologicEvent[@gml:id='gsml.geologicevent.16777549126930541']/gsml:eventProcess/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:geologicHistory", doc);
        this.assertXpathEvaluatesTo("recessive", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gsml:outcropCharacter/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("dyke", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126931275']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Morphology", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126931275']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107855939']/gsml:part", doc);
        this.assertXpathEvaluatesTo("indurated", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107855939']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:ConsolidationDegree", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107855939']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("indurated", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107855964']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:ConsolidationDegree", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491233249211']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107855964']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("indurated", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107856083']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:ConsolidationDegree", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107856083']/gsml:consolidationDegree/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:granodiorite", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107856083']/gsml:lithology/@xlink:href", doc);
        this.assertXpathEvaluatesTo("all", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Proportion", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858185']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858173']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858161']", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:shale", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858185']/gsml:lithology/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:sandstone", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858173']/gsml:lithology/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:SimpleLithology:2008:mudstone", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']/gsml:composition/gsml:CompositionPart/gsml:material/gsml:RockMaterial[@gml:id='gsml.rockmaterial.167775491107858161']/gsml:lithology/@xlink:href", doc);
        this.assertXpathCount(4, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932958']/gsml:part", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932958']/gsml:part/gsml:GeologicUnitPart/gsml:proportion/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("2.707", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932676']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:g.cm-3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932676']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("2.114", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("2.955", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932776']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:density/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("900.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM::SI", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491110573732']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("55.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513320744']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:lower/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("230.0", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513320744']/gsml:physicalProperty/gsml:PhysicalDescription/gsml:magneticSusceptibility/gsml:CGI_NumericRange/gsml:upper/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gml:name", doc);
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gml:name[1]", doc));
        ls.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gml:name[2]", doc));
        Assert.assertTrue((boolean)ls.contains("Silverband Formation (Sks)"));
        Assert.assertTrue((boolean)ls.contains("urn:cgi:feature:GSV:GeologicUnit:167775491107838881"));
        ls.clear();
        ls.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gml:name[1]/@codeSpace", doc));
        ls.add(this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107838881']/gml:name[2]/@codeSpace", doc));
        Assert.assertTrue((boolean)ls.contains("http://www.dpi.vic.gov.au/earth-resources"));
        Assert.assertTrue((boolean)ls.contains("http://www.ietf.org/rfc/rfc2141"));
        this.assertXpathEvaluatesTo("Intrusion [rank]", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:rank", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Lithodemic_IntrusiveUnitRank", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.1677754911513318041']/gsml:rank/@codeSpace", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126932676']/gsml:purpose", doc);
    }

    @Test
    public void testContact() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:Contact&featureid=gsml.contact.46233,gsml.contact.46235";
        this.validateGet(path);
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info(this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("2", "//wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(153, "//gsml:Contact[@gml:id='gsml.contact.46233']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:Contact[@gml:id='gsml.contact.46233']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:Contact[@gml:id='gsml.contact.46233']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:GSV:Contact:46233", "//gsml:Contact[@gml:id='gsml.contact.46233']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:ContactType:200811:igneous_intrusive_contact", "//gsml:Contact[@gml:id='gsml.contact.46233']/gsml:contactType/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net/", "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:GSV:Contact:46235", "//gsml:Contact[@gml:id='gsml.contact.46235']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:CGI:ContactType:200811:igneous_phase_contact", "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:contactType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.182366']", doc);
        this.assertXpathCount(1, "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.185193']", doc);
        this.assertXpathCount(1, "//gsml:Contact[@gml:id='gsml.contact.46235']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.185608']", doc);
    }

    @Test
    public void testShearDisplacement() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:ShearDisplacementStructure&featureid=gsml.sheardisplacementstructure.46179,gsml.sheardisplacementstructure.46181,gsml.sheardisplacementstructure.46188,gsml.sheardisplacementstructure.46199,gsml.sheardisplacementstructure.46216";
        this.validateGet(path);
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info(this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("5", "//wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(12, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(2, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46181']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(4, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46216']/gsml:occurrence/gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Holocene", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("reverse", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementSense/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Provisional:MovementSense", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementSense/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("dip-slip", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementType/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Provisional:MovementType", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementType/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("SSE", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:GmlCompassPointEnumeration", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46179']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000003']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46181']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.185969']", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46181']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.186045']", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46181']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000008']", doc);
        this.assertXpathCount(1, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46181']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000007']", doc);
        this.assertXpathCount(10, "//gsml:ShearDisplacementStructure/gsml:geologicHistory/gsml:DisplacementEvent", doc);
        this.assertXpathEvaluatesTo("typicalNorm", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46216']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46216']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.185911']/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(2, "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gml:name", doc);
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(this.evaluate("//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gml:name[1]", doc));
        ls.add(this.evaluate("//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gml:name[2]", doc));
        Assert.assertTrue((boolean)ls.contains("Castle Cove Fault"));
        Assert.assertTrue((boolean)ls.contains("urn:cgi:feature:GSV:ShearDisplacementStructure:46188"));
        ls.clear();
        ls.add(this.evaluate("//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gml:name[1]/@codeSpace", doc));
        ls.add(this.evaluate("//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46188']/gml:name[2]/@codeSpace", doc));
        Assert.assertTrue((boolean)ls.contains("http://www.dpi.vic.gov.au/earth-resources"));
        Assert.assertTrue((boolean)ls.contains("http://www.ietf.org/rfc/rfc2141"));
        this.assertXpathEvaluatesTo("S", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:GmlCompassPointEnumeration", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:hangingWallDirection/gsml:CGI_LinearOrientation/gsml:descriptiveOrientation/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("normal", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementSense/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Provisional:MovementSense", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementSense/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("dip-slip", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementType/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:Provisional:MovementType", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:incrementalDisplacement/gsml:DisplacementValue/gsml:movementType/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Permian", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifier:ICS:StratChart:2008:Permian", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:ICS:StratChart:2008", "//gsml:ShearDisplacementStructure[@gml:id='gsml.sheardisplacementstructure.46199']/gsml:geologicHistory/gsml:DisplacementEvent[@gml:id='gsml.displacementevent.1000037']/gsml:eventAge/gsml:CGI_TermRange/gsml:upper/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
    }

    @Test
    public void testMappedFeature() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:MappedFeature&featureid=gsml.mappedfeature.195201,gsml.mappedfeature.192654,gsml.mappedfeature.191921,gsml.mappedfeature.179239,gsml.mappedfeature.185969,gsml.mappedfeature.186037,gsml.mappedfeature.185817,gsml.mappedfeature.185911,gsml.mappedfeature.178855,gsml.mappedfeature.185608";
        this.validateGet(path);
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info(this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("10", "//wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(10, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("previous mapping", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.179239']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:InterpretationMethod", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.179239']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("approximate", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.185608']/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("urn:cgi:classifierScheme:GSV:PositionalAccuracy", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.185608']/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.185911']/gsml:samplingFrame/@xlink:href", doc);
        ArrayList<String> specs = new ArrayList<String>();
        for (int i = 1; i <= 10; ++i) {
            specs.add(this.evaluate("/wfs:FeatureCollection/gml:featureMember[" + i + "]/gsml:MappedFeature/gsml:specification/@xlink:href", doc));
        }
        int[] countType = new int[3];
        for (String spec : specs) {
            if (spec.contains("ShearDisplacementStructure")) {
                countType[0] = countType[0] + 1;
            }
            if (spec.contains("GeologicUnit")) {
                countType[1] = countType[1] + 1;
            }
            if (!spec.contains("Contact")) continue;
            countType[2] = countType[2] + 1;
        }
        Assert.assertEquals((long)5L, (long)countType[0]);
        Assert.assertEquals((long)3L, (long)countType[1]);
        Assert.assertEquals((long)2L, (long)countType[2]);
        String expected = "-38.410785700000325 143.86545265833303 -38.40925703333365 143.86857949166634";
        String actual = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.179239']/gsml:shape/gml:MultiCurve/gml:curveMember/gml:LineString/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(actual, expected, 5));
        expected = "-38.139133550000324 144.2364237333331 -38.13991570000029 144.2415325499997";
        actual = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.185969']/gsml:shape/gml:MultiCurve/gml:curveMember/gml:LineString/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(actual, expected, 5));
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.192654']/gsml:shape/gml:MultiSurface/@srsDimension", doc);
        expected = "-37.469102166666666 143.76702998333334 -37.470454841666665 143.76797201666668 -37.4716163 143.76817698333332 -37.472777758333336 143.7679037 -37.473939216666665 143.76776705833333 -37.475100675 143.76797201666668 -37.475715566666665 143.76899683333335 -37.476877025 143.76927011666666 -37.478038483333336 143.76933844166666 -37.4790633 143.76988500833335 -37.480224766666666 143.76974836666668 -37.480293083333336 143.76858690833333 -37.480088125 143.76742545 -37.478516733333336 143.76571741666666 -37.479336591666666 143.76489756666666 -37.47954155 143.76257465 -37.480429725 143.76332618333333 -37.481591183333336 143.7633945 -37.482684325 143.76291625 -37.483367533333336 143.760729975 -37.4835725 143.75956851666666 -37.48364083333333 143.75840705833335 -37.483504175 143.7572456 -37.482889291666666 143.75622078333333 -37.48213775833334 143.75533260833333 -37.481864475 143.75417114166666 -37.4822744 143.751848225 -37.4822744 143.75068676666666 -37.48213775833334 143.74952530833335 -37.479814833333336 143.749252025 -37.479609875 143.74809055833333 -37.47954155 143.7469291 -37.47865338333333 143.74617756666666 -37.477560241666666 143.74583596666668 -37.47721863333334 143.744742825 -37.47721863333334 143.74358136666666 -37.47694535 143.74241990833335 -37.476193808333335 143.740233625 -37.476193808333335 143.73907216666666 -37.476398775 143.73791070833335 -37.4774236 143.73579275 -37.476877025 143.73476793333333 -37.4764671 143.7336748 -37.475783891666666 143.7327183 -37.474827391666665 143.730532025 -37.474622425 143.72937056666666 -37.474554108333336 143.72820910833335 -37.474622425 143.7265694 -37.473460966666664 143.7265694 -37.47236784166667 143.726979325 -37.471547975 143.727799175 -37.470386516666665 143.727799175 -37.469293375 143.72738925 -37.4684052 143.72663771666666 -37.468131916666664 143.72547625833334 -37.467312066666665 143.72445143333334 -37.466355566666664 143.72410983333333 -37.465262433333336 143.72438313333333 -37.464784183333336 143.72547625833334 -37.464647541666665 143.72663771666666 -37.464784183333336 143.727799175 -37.465262433333336 143.72889231666667 -37.465809 143.72991713333334 -37.466492208333335 143.73087363333335 -37.467380383333335 143.73169348333334 -37.469498341666664 143.734426325 -37.4703182 143.73531450833335 -37.470933083333335 143.736339325 -37.472299508333336 143.73825231666666 -37.473051041666665 143.73914049166666 -37.474075858333336 143.74125845 -37.474417466666665 143.74235158333335 -37.474485783333336 143.74351304166666 -37.474759075 143.74467450833333 -37.47544228333334 143.745631 -37.475783891666666 143.74672414166668 -37.47598885 143.7478856 -37.4764671 143.74897873333333 -37.476535425 143.75246311666666 -37.476125491666664 143.75355625833333 -37.4755106 143.754581075 -37.473597608333336 143.75594749166666 -37.472777758333336 143.75676735 -37.472299508333336 143.75786048333333 -37.47236784166667 143.76018340833332 -37.47209455 143.76134486666666 -37.469293375 143.76517085 -37.469020091666664 143.76633230833335 -37.469102166666666 143.76702998333334";
        actual = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.192654']/gsml:shape/gml:MultiSurface/gml:surfaceMember/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(actual, expected, 5));
    }

    @Test
    public void testPredicates() {
        if (AppSchemaDataAccessConfigurator.isJoining()) {
            String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gsml:geologicHistory/gsml:GeologicEvent/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue[gsml:value/@codeSpace='urn:cgi:classifierScheme:ICS:StratChart:2008']/gsml:value</ogc:PropertyName>                <ogc:Literal>urn:cgi:classifier:ICS:StratChart:2008:Devonian</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
            this.validate(xml);
            Document doc = this.postAsDOM("wfs", xml);
            if (this.printDoc) {
                LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
            }
            this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
            this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.167775491107843155']", doc);
            this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126941436']", doc);
            this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126942588']", doc);
            xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gsml:geologicHistory/gsml:GeologicEvent/gsml:eventAge/gsml:CGI_TermRange/gsml:lower/gsml:CGI_TermValue[gsml:value/@codeSpace='urn:cgi:classifierScheme:ICS:StratChart:2008z']/gsml:value</ogc:PropertyName>                <ogc:Literal>urn:cgi:classifier:ICS:StratChart:2008:Devonian</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
            this.validate(xml);
            doc = this.postAsDOM("wfs", xml);
            if (this.printDoc) {
                LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
            }
            this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
            xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name[substring(@codeSpace,3)='tp://www.dpi.vic.gov.au/earth-resources']</ogc:PropertyName>                <ogc:Literal>Nelson Creek Granite (G191)</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
            this.validate(xml);
            doc = this.postAsDOM("wfs", xml);
            if (this.printDoc) {
                LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
            }
            this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
            this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126942588']", doc);
            xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:GeologicUnit\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name[substring(@codeSpace,2)='tp://www.dpi.vic.gov.au/earth-resources']</ogc:PropertyName>                <ogc:Literal>Nelson Creek Granite (G191)</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
            this.validate(xml);
            doc = this.postAsDOM("wfs", xml);
            if (this.printDoc) {
                LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
            }
            this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
        }
    }

    @Test
    public void testReprojectionInFeatureChaining() {
        String path = "wfs?request=GetFeature&srsName=urn:x-ogc:def:crs:EPSG:4326&version=1.1.0&typeName=gsml:GeologicUnit&featureid=gsml.geologicunit.16777549126930540";
        Document doc = this.getAsDOM(path);
        if (this.printDoc) {
            LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        }
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191322']/gsml:shape/gml:MultiSurface/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191322']/gsml:shape/gml:MultiSurface/@srsDimension", doc);
        String expected = "-36.91391191948047 144.0478089083333 -36.91535066114876 144.04748426666666 -36.915274969482006 144.04633634166666 -36.91504654448175 144.0451942 -36.91510365281515 144.04405205833336 -36.91510365281515 144.04290991666667 -36.91476101114809 144.04211040833334 -36.91418048614744 144.04222736666668 -36.91336111114652 144.04308674166666 -36.912202486145226 144.04339155 -36.91174298614471 144.04447269166667 -36.91133763614426 144.04556750833333 -36.91071870281022 144.04663162500003 -36.910000569476075 144.047540275 -36.90946055280882 144.048551125 -36.90943138614211 144.04873191666667 -36.909494336142174 144.04969045833334 -36.9095378778089 144.04975733333333 -36.910296377809736 144.050369725 -36.91135182781094 144.04991965833332 -36.91220002781188 144.04912606666667 -36.913342494479835 144.04889391666663 -36.91391191948047 144.0478089083333";
        String orig = this.evaluate("//gsml:GeologicUnit[@gml:id='gsml.geologicunit.16777549126930540']/gsml:occurrence/gsml:MappedFeature[@gml:id='gsml.mappedfeature.191322']/gsml:shape/gml:MultiSurface/gml:surfaceMember/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        Assert.assertTrue((boolean)this.isEqualGeometry(orig, expected, 5));
    }

    @Test
    public void testFilteringSplit() throws Exception {
        FeatureSource<FeatureType, Feature> featureSource;
        if (AppSchemaDataAccessConfigurator.isJoining()) {
            return;
        }
        try {
            Name gu = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnit");
            featureSource = this.getFeatureSource(gu);
        }
        catch (IOException ioe) {
            featureSource = null;
        }
        Assert.assertNotNull(featureSource);
        ArrayList<PropertyIsLike> filterList = new ArrayList<PropertyIsLike>();
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(((MappingFeatureSource)featureSource).getMapping().getNamespaces());
        PropertyName property = ff.property("gsml:geologicHistory/gsml:GeologicEvent/gsml:eventEnvironment/gsml:CGI_TermValue/gsml:value");
        PropertyIsLike filter = ff.like((Expression)property, "*mid-crustal*");
        filterList.add(filter);
        property = ff.property("gsml:purpose");
        filter = ff.like((Expression)property, "*ypical*");
        filterList.add(filter);
        And andFilter = ff.and(filterList);
        FeatureCollection filteredResults = featureSource.getFeatures((Filter)andFilter);
        try (FeatureIterator iterator = filteredResults.features();){
            Assert.assertTrue((boolean)(filteredResults instanceof MappingFeatureCollection));
            MappingFeatureCollection mfc = (MappingFeatureCollection)filteredResults;
            Filter afterSplit = mfc.getQuery().getFilter();
            Assert.assertTrue((boolean)(afterSplit instanceof LikeFilterImpl));
            Assert.assertEquals((Object)"*ypical*", (Object)((LikeFilterImpl)afterSplit).getLiteral());
            ArrayList<String> ids = new ArrayList<String>();
            while (iterator.hasNext()) {
                ids.add(iterator.next().getIdentifier().toString());
            }
            Assert.assertEquals((long)3L, (long)ids.size());
            Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.1677754911513315832"));
            Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126941084"));
            Assert.assertTrue((boolean)ids.contains("gsml.geologicunit.16777549126942588"));
        }
    }

    public FeatureSource<FeatureType, Feature> getFeatureSource(Name feature) throws IOException {
        DataAccess mfDataAccess = AppSchemaDataAccessRegistry.getDataAccess((Name)feature);
        return mfDataAccess.getFeatureSource(feature);
    }
}

